/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.handler;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.Handler;
import com.ds.server.httpproxy.core.Http;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class BasicWebAuthHandler
extends AbstractHandler
implements Handler {
    private static final Log log = LogFactory.getLog((String)"JDS", BasicWebAuthHandler.class);
    private Properties users;
    public static final ConfigOption REALM_OPTION = new ConfigOption("realm", "", "The default realm to authenticate against.");
    public static final ConfigOption USERS_OPTION = new ConfigOption("users", true, "The file used to authenticate users.");

    @Override
    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.users = new Properties();
        return this.loadProperties();
    }

    private boolean loadProperties() {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(USERS_OPTION.getProperty(this.server, this.handlerName)));
            this.users.load(is);
            ((InputStream)is).close();
            return true;
        }
        catch (IOException e) {
            log.info((Object)"loadPropeties failed due to IOException.", (Throwable)e);
            return false;
        }
    }

    @Override
    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        String auth = request.getRequestHeader("Authorization");
        if (auth == null) {
            return this.askForAuthorization(request, response);
        }
        int index = auth.indexOf(" ");
        if (index < -1) {
            return this.askForAuthorization(request, response);
        }
        auth = auth.substring(index + 1);
        BASE64Decoder decoder = new BASE64Decoder();
        auth = new String(decoder.decodeBuffer(auth));
        String[] credentials = auth.split(":");
        try {
            if (!this.users.containsKey(credentials[0]) || !this.isPasswordVerified(credentials)) {
                log.warn((Object)("Access denied for user " + credentials[0]));
                return this.askForAuthorization(request, response);
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.warn((Object)"Authorization failed due to NoSuchAlgorithmException.", (Throwable)e);
            response.sendError(500, Http.getStatusPhrase(500));
            return true;
        }
        return false;
    }

    private boolean isPasswordVerified(String[] credentials) throws NoSuchAlgorithmException {
        return BasicWebAuthHandler.hashPassword(credentials[1]).equals(this.users.getProperty(credentials[0]));
    }

    private boolean askForAuthorization(HttpRequest request, HttpResponse response) {
        String realm = REALM_OPTION.getProperty(this.server, this.handlerName);
        response.addHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
        response.sendError(401, Http.getStatusPhrase(401));
        return true;
    }

    private static String hashPassword(String password) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] md5password = md5.digest(password.getBytes());
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(md5password);
    }

    public static void main(String[] args) throws IOException, NoSuchAlgorithmException {
        if (args.length < 3) {
            System.out.println("Usage: BasicWebAuthHandler <file> <user> <password>");
            return;
        }
        File userFile = new File(args[0]);
        Properties users = new Properties();
        if (userFile.exists()) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(userFile));
            users.load(is);
            ((InputStream)is).close();
        }
        System.out.println("Creating hash for " + args[1]);
        users.setProperty(args[1], BasicWebAuthHandler.hashPassword(args[2]));
        System.out.println("Writing password for " + args[1]);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(userFile));
        users.store(os, "");
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
        System.out.println("done");
    }

    @Override
    public boolean shutdown(Server server) {
        return false;
    }
}

