/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ThreadPool {
    private static final Log log = LogFactory.getLog((String)"JDS", ThreadPool.class);
    private List threads = new ArrayList();
    private LinkedList queue = new LinkedList();

    public ThreadPool(int numberOfThreads) {
        for (int i = 0; i < numberOfThreads; ++i) {
            log.debug((Object)("Creating thread " + i));
            PooledThread thread = new PooledThread("Pooled Thread " + i);
            thread.start();
            this.threads.add(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable) {
        log.debug((Object)"Queueing runnable in thread pool.");
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(runnable);
            this.queue.notify();
        }
    }

    public void shutdown() {
        for (int i = 0; i < this.threads.size(); ++i) {
            Thread thread = (Thread)this.threads.get(i);
            thread.interrupt();
        }
    }

    protected class PooledThread
    extends Thread {
        public PooledThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    this.waitForTask();
                    Runnable runnable = this.retrieveTask();
                    if (runnable != null) {
                        log.debug((Object)("Starting runnable on thread " + Thread.currentThread().getName()));
                        try {
                            runnable.run();
                        }
                        catch (Exception e) {
                            log.error((Object)e.toString(), (Throwable)e);
                        }
                    }
                    log.debug((Object)("Returning to thread pool " + Thread.currentThread().getName()));
                }
            }
            catch (InterruptedException e) {
                log.error((Object)Thread.currentThread().getName(), (Throwable)e);
            }
            finally {
                log.info((Object)(Thread.currentThread().getName() + " is shutting down"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForTask() throws InterruptedException {
            LinkedList linkedList = ThreadPool.this.queue;
            synchronized (linkedList) {
                if (ThreadPool.this.queue.isEmpty()) {
                    ThreadPool.this.queue.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Runnable retrieveTask() {
            Runnable runnable = null;
            LinkedList linkedList = ThreadPool.this.queue;
            synchronized (linkedList) {
                if (!ThreadPool.this.queue.isEmpty()) {
                    runnable = (Runnable)ThreadPool.this.queue.removeFirst();
                }
            }
            return runnable;
        }
    }
}

