/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.EndPoint;
import com.ds.server.httpproxy.core.NonBlockingRunnable;
import com.ds.server.httpproxy.core.Server;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SingleThreadedHttpEndPoint
implements EndPoint,
Runnable {
    private static final Log log = LogFactory.getLog((String)"JDS", SingleThreadedHttpEndPoint.class);
    private static final ConfigOption PORT_OPTION = new ConfigOption("port", "8082", "HTTP server port");
    private static final ConfigOption BUFFER_SIZE_OPTION = new ConfigOption("buffersize", "1024", "Read buffer size.");
    private String endpointName;
    private Server server;
    private ByteBuffer byteBuffer;
    private Thread mainThread;
    private int socketPort = 80;

    @Override
    public void initialize(String name, Server server) throws IOException {
        this.endpointName = name;
        this.server = server;
        try {
            this.socketPort = PORT_OPTION.getInteger(server, this.endpointName);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int size = 1024;
        try {
            size = BUFFER_SIZE_OPTION.getInteger(server, this.endpointName);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.byteBuffer = ByteBuffer.allocateDirect(size);
    }

    @Override
    public String getName() {
        return this.endpointName;
    }

    @Override
    public void start() {
        this.mainThread = new Thread((Runnable)this, this.endpointName + "[" + this.socketPort + "] ServerSocketEndPoint");
        this.mainThread.setDaemon(true);
        this.mainThread.start();
    }

    @Override
    public void run() {
        Selector selector = null;
        try {
            selector = this.createSelector(this.socketPort);
            boolean keepProcessing = true;
            while (keepProcessing) {
                keepProcessing = this.processIncomingConnections(selector);
            }
        }
        catch (IOException e) {
            this.logException(Level.SEVERE, e);
        }
        finally {
            if (selector != null) {
                try {
                    selector.close();
                }
                catch (IOException iOException) {}
            }
            this.mainThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processIncomingConnections(Selector selector) {
        try {
            selector.select();
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            Iterator<SelectionKey> it = selector.selectedKeys().iterator();
            while (it.hasNext()) {
                SelectionKey key = it.next();
                try {
                    this.handleKey(selector, key);
                }
                catch (IOException ioe) {
                    this.logException(Level.WARNING, ioe);
                    ((DirectionalTransfer)key.attachment()).closeClient();
                }
                finally {
                    it.remove();
                }
            }
        }
        catch (Exception e) {
            this.logException(Level.SEVERE, e);
        }
        return true;
    }

    private void logException(Level logLevel, Throwable e) {
        LogRecord record = new LogRecord(logLevel, e.getMessage());
        record.setThrown(e);
        log.error((Object)record);
    }

    @Override
    public void shutdown(Server server) {
        if (this.mainThread != null) {
            this.mainThread.interrupt();
        }
    }

    private Selector createSelector(int port) throws IOException {
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        Selector selector = Selector.open();
        serverChannel.socket().bind(new InetSocketAddress(port));
        serverChannel.configureBlocking(false);
        serverChannel.register(selector, 16);
        return selector;
    }

    private void handleKey(Selector selector, SelectionKey key) throws IOException {
        if (key.isAcceptable()) {
            this.acceptNewClient(selector, key);
        } else if (key.isReadable()) {
            this.readDataFromSocket(key);
        }
    }

    private void acceptNewClient(Selector selector, SelectionKey key) throws IOException {
        ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
        SocketChannel channel = serverChannel.accept();
        channel.configureBlocking(false);
        Client client = new Client(channel);
        client.out.source().register(selector, 1, client.getTransferToSocket());
        channel.register(selector, 1, client.getTransferToWorker());
        this.server.post(new NonBlockingRunnable(this.server, channel.socket(), client.getTransferToWorker(), client.getTransferToSocket()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDataFromSocket(SelectionKey key) throws IOException {
        try {
            int count = ((ReadableByteChannel)((Object)key.channel())).read(this.byteBuffer);
            if (count > 0) {
                this.byteBuffer.flip();
                DirectionalTransfer direction = (DirectionalTransfer)key.attachment();
                direction.transfer(this.byteBuffer);
            } else if (count < 0) {
                ((DirectionalTransfer)key.attachment()).closeClient();
            }
        }
        finally {
            this.byteBuffer.clear();
        }
    }

    public static class TransferToSocket
    extends OutputStream
    implements DirectionalTransfer {
        Client client;
        byte[] byte1;

        public TransferToSocket(Client client) {
            this.client = client;
        }

        @Override
        public void transfer(ByteBuffer data) throws IOException {
            int written = this.client.channel.write(data);
            if (written == 0) {
                System.out.println("Written to socket: " + written);
            }
        }

        @Override
        public void closeClient() throws IOException {
            this.client.in.source().close();
            this.client.out.sink().close();
        }

        @Override
        public void write(int b) throws IOException {
            if (this.byte1 == null) {
                this.byte1 = new byte[1];
            }
            this.byte1[0] = (byte)b;
            this.client.out.sink().write(ByteBuffer.wrap(this.byte1));
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
            while (buffer.hasRemaining()) {
                int written = this.client.out.sink().write(buffer);
                if (written != 0) continue;
                Thread.yield();
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static class TransferToWorker
    extends InputStream
    implements DirectionalTransfer {
        Client client;

        public TransferToWorker(Client client) {
            this.client = client;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
            return this.client.in.source().read(buffer);
        }

        @Override
        public int read() throws IOException {
            byte[] byte1 = new byte[1];
            int count = 0;
            while (count == 0) {
                count = this.read(byte1);
            }
            if (count > 0) {
                return byte1[0];
            }
            return count;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void transfer(ByteBuffer data) throws IOException {
            int count = this.client.in.sink().write(data);
            if (count == 0 || data.hasRemaining()) {
                System.out.println("Count: " + count + " remaing: " + data.hasRemaining());
            }
        }

        @Override
        public void closeClient() throws IOException {
            this.client.channel.close();
            this.client.in.sink().close();
            this.client.out.source().close();
        }
    }

    public static class Client {
        SocketChannel channel;
        Pipe in;
        Pipe out;
        TransferToSocket socketTransfer;
        TransferToWorker workerTransfer;

        public Client(SocketChannel aChannel) throws IOException {
            this.channel = aChannel;
            this.in = Pipe.open();
            this.out = Pipe.open();
            this.in.sink().configureBlocking(false);
            this.out.source().configureBlocking(false);
            this.socketTransfer = new TransferToSocket(this);
            this.workerTransfer = new TransferToWorker(this);
        }

        public TransferToSocket getTransferToSocket() {
            return this.socketTransfer;
        }

        public TransferToWorker getTransferToWorker() {
            return this.workerTransfer;
        }
    }

    public static interface DirectionalTransfer {
        public void transfer(ByteBuffer var1) throws IOException;

        public void closeClient() throws IOException;
    }
}

