/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.server.httpproxy.core.ChainableProperties;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.ConnectionRunnable;
import com.ds.server.httpproxy.core.EndPoint;
import com.ds.server.httpproxy.core.Server;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import javax.net.ServerSocketFactory;

public class ServerSocketEndPoint
implements EndPoint,
Runnable {
    private static final Log log = LogFactory.getLog((String)"JDS", ServerSocketEndPoint.class);
    private static final ConfigOption PORT_OPTION = new ConfigOption("port", "8082", "HTTP server port.");
    private static final ConfigOption RESOLVE_HOSTNAME_OPTION = new ConfigOption("resolveHostName", "false", "Resolve host names");
    protected ServerSocketFactory factory = ServerSocketFactory.getDefault();
    protected ServerSocket socket;
    protected Server server;
    protected String endpointName;
    protected boolean resolveHostName;

    @Override
    public void initialize(String name, Server server) throws IOException {
        this.endpointName = name;
        this.server = server;
        this.resolveHostName = RESOLVE_HOSTNAME_OPTION.getBoolean(server, this.endpointName);
    }

    @Override
    public String getName() {
        return this.endpointName;
    }

    protected ServerSocket createSocket(int port) throws IOException {
        ServerSocket socket = this.factory.createServerSocket(port);
        return socket;
    }

    @Override
    public void start() throws IOException {
        this.socket = this.createSocket(PORT_OPTION.getInteger(this.server, this.endpointName));
        log.info((Object)("Socket listening on port " + this.socket.getLocalPort()));
        Thread thread = new Thread((Runnable)this, this.endpointName + "[" + this.socket.getLocalPort() + "] ServerSocketEndPoint");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Socket client = this.socket.accept();
                ChainableProperties config = new ChainableProperties(this.server.getConfig());
                Runnable runnable = this.createRunnable(client, config);
                if (this.resolveHostName) {
                    InetAddress clientAddress = client.getInetAddress();
                    clientAddress.getHostName();
                }
                log.debug((Object)("Connection from: " + client.toString()));
                this.server.post(runnable);
            }
        }
        catch (IOException e) {
            log.warn((Object)"IOException ignored", (Throwable)e);
            return;
        }
    }

    private String getHost(Socket socket) {
        String host = this.server.getProperty("host");
        if (host != null) {
            return host;
        }
        return socket.getLocalAddress().getHostName();
    }

    protected String getProtocol() {
        return "http";
    }

    protected Runnable createRunnable(Socket client, Properties config) throws IOException {
        ConnectionRunnable runnable = new ConnectionRunnable(this.server, this.getProtocol(), client, config);
        return runnable;
    }

    @Override
    public void shutdown(Server server) {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

