/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.JDSUtil;
import com.ds.server.httpproxy.config.Handle;
import com.ds.server.httpproxy.core.ChainableProperties;
import com.ds.server.httpproxy.core.EndPoint;
import com.ds.server.httpproxy.core.Handler;
import com.ds.server.httpproxy.core.ProxyHost;
import com.ds.server.httpproxy.core.Request;
import com.ds.server.httpproxy.core.Response;
import com.ds.server.httpproxy.core.ResponseListener;
import com.ds.server.httpproxy.core.ThreadPool;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.LogManager;

public class Server
implements Runnable {
    private static final Log log = LogFactory.getLog((String)"JDS", Server.class);
    private ProxyHost proxyHost;
    Properties config = new ChainableProperties();
    HashMap endpoints = new HashMap();
    HashMap<String, Map> session = new HashMap();
    Handler handler = null;
    ResponseListener responseListener = null;
    ThreadPool threadPool;
    public boolean started = false;
    private static final String CLAZZ = ".class";

    public Server(String filename) throws IOException {
        try (InputStream is = null;){
            is = new BufferedInputStream(new FileInputStream(filename));
            this.config.load(is);
        }
        Server.setDefaultProperties(this.config);
    }

    public Server() {
        this.config = new ChainableProperties();
        Server.setDefaultProperties(this.config);
        try {
            this.setupLogging(this.config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Server(ProxyHost host) {
        this.proxyHost = host;
        Properties props = new Properties();
        try {
            File engineConfigFile = new File(JDSUtil.getJdsRealPath(), "server.properties");
            props.load(new FileInputStream(engineConfigFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        props.setProperty("http.port", host.getPort());
        ChainableProperties config = new ChainableProperties(props);
        Server.setDefaultProperties(config);
        this.config = config;
        try {
            this.setupLogging(config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Server(Properties config) {
        Server.setDefaultProperties(config);
        try {
            this.setupLogging(config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.config = config;
    }

    public Server(String[] args) throws IOException {
        this.config = new ChainableProperties();
        this.processArguments(args, this.config);
    }

    public void addEndPoint(String name, EndPoint endpoint) {
        this.endpoints.put(name, endpoint);
    }

    public void putProperty(Object key, Object value) {
        this.config.put(key, value);
    }

    public String getProperty(String key) {
        return this.config.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.config.getProperty(key, defaultValue);
        return value;
    }

    public ProxyHost getProxyHost() {
        if (this.proxyHost == null) {
            this.proxyHost = new ProxyHost();
            this.proxyHost.setLocalIp(this.getLocalIp());
            this.proxyHost.setPort(this.getProperty("http.port"));
        }
        return this.proxyHost;
    }

    public void setProxyHost(ProxyHost proxyHost) {
        this.proxyHost = proxyHost;
    }

    public boolean hasProperty(String key) {
        return this.config.containsKey(key);
    }

    public Object get(Object key) {
        return this.config.get(key);
    }

    public Properties getConfig() {
        return this.config;
    }

    public Object getRegisteredComponent(Class clazz) {
        return this.config.get(clazz);
    }

    public void registerComponent(Object object) {
        this.config.put(object.getClass(), object);
    }

    public void start() throws IOException {
        if (!this.started) {
            log.info((Object)"################################################################################");
            log.info((Object)("--------JDSConsoleServer Start---------port: [" + this.config.get("http.port") + "]-----------"));
            log.info((Object)"#################################################################################");
            log.info((Object)"--------JDSConsoleServer InitEndPoint-----------");
            this.initializeThreads();
            this.initializeHandler();
            if (this.handler == null) {
                return;
            }
            this.constructEndPoints();
            for (EndPoint currentEndPoint : this.endpoints.values()) {
                try {
                    currentEndPoint.start();
                }
                catch (IOException e) {
                    this.shutdown();
                    throw e;
                }
            }
            log.info((Object)"#################################################################################");
            this.started = true;
        }
    }

    private void initializeThreads() {
        try {
            this.threadPool = new ThreadPool(Integer.parseInt(this.config.getProperty("threadpool.size", "150")));
        }
        catch (NumberFormatException e) {
            log.warn((Object)"threadpool.size was not a number using default of 150");
            this.threadPool = new ThreadPool(150);
        }
    }

    protected void initializeHandler() {
        if (this.handler == null) {
            this.handler = (Handler)this.constructJdsObject(this.getProperty("handler"));
        }
        this.handler.initialize(this.getProperty("handler"), this);
    }

    public Object constructJdsObject(Handle handle) {
        Object theObject = null;
        String objectClassname = handle.getClassname();
        try {
            if (objectClassname == null) {
                throw new ClassNotFoundException(objectClassname + CLAZZ + " configuration property not found.");
            }
            Class<?> handlerClass = Class.forName(objectClassname);
            Constructor<?>[] constructors = handlerClass.getConstructors();
            Class<?>[] paramClass = constructors[0].getParameterTypes();
            Object[] params = new Object[paramClass.length];
            for (int i = 0; i < paramClass.length; ++i) {
                params[i] = paramClass[i].equals(Server.class) ? this : (paramClass[i].equals(Handle.class) ? handle : this.getRegisteredComponent(paramClass[i]));
            }
            theObject = constructors[0].newInstance(params);
            log.info((Object)("JDSConsoleServer object constructed. object=" + handle.getHandleid() + " class=" + objectClassname));
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Could not access constructor.  Make sure it has the constructor is public.  Service not started.  class=" + objectClassname), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)("Could not instantiate object.  Service not started.  class=" + objectClassname), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Could not find class.  Service not started.  class=" + objectClassname), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)("Could not instantiate object because constructor threw an exception.  Service not started.  class=" + objectClassname), (Throwable)e);
            log.error((Object)"Cause:", e.getTargetException());
        }
        return theObject;
    }

    public Object constructJdsObject(String objectName) {
        Object theObject = null;
        String objectClassname = this.getProperty(objectName + CLAZZ);
        try {
            if (objectClassname == null) {
                throw new ClassNotFoundException(objectName + CLAZZ + " configuration property not found.");
            }
            Class<?> handlerClass = Class.forName(objectClassname);
            Constructor<?>[] constructors = handlerClass.getConstructors();
            Class<?>[] paramClass = constructors[0].getParameterTypes();
            Object[] params = new Object[paramClass.length];
            for (int i = 0; i < paramClass.length; ++i) {
                params[i] = paramClass[i].equals(Server.class) ? this : (paramClass[i].equals(String.class) ? objectName : this.getRegisteredComponent(paramClass[i]));
            }
            theObject = constructors[0].newInstance(params);
            log.info((Object)("Jds object constructed. object=" + objectName + " class=" + objectClassname));
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Could not access constructor.  Make sure it has the constructor is public.  Service not started.  class=" + objectClassname), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)("Could not instantiate object.  Service not started.  class=" + objectClassname), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Could not find class.  Service not started.  class=" + objectClassname), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            log.error((Object)("Could not instantiate object because constructor threw an exception.  Service not started.  class=" + objectClassname), (Throwable)e);
            log.error((Object)"Cause:", e.getTargetException());
        }
        return theObject;
    }

    private void constructEndPoints() {
        String val = this.getProperty("endpoints");
        if (val != null) {
            StringTokenizer tokenizer = new StringTokenizer(val);
            while (tokenizer.hasMoreTokens()) {
                String endPointName = tokenizer.nextToken();
                try {
                    EndPoint endPoint = (EndPoint)this.constructJdsObject(endPointName);
                    endPoint.initialize(endPointName, this);
                    this.addEndPoint(endPointName, endPoint);
                }
                catch (IOException e) {
                    log.error((Object)(endPointName + " was not initialized properly."), (Throwable)e);
                }
            }
        } else {
            log.error((Object)"No endpoints defined.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.shutdown();
        Server server = this;
        synchronized (server) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        log.info((Object)"Starting shutdown.");
        try {
            Collection values;
            this.threadPool.shutdown();
            if (this.handler != null) {
                log.info((Object)"Shutting down handlers.");
                this.handler.shutdown(this);
            }
            if ((values = this.endpoints.values()) != null) {
                for (EndPoint currentEndPoint : values) {
                    log.info((Object)("Shutting down endpoint " + currentEndPoint.getName()));
                    currentEndPoint.shutdown(this);
                }
            }
        }
        finally {
            log.info((Object)"Shutdown complete.");
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean post(Request request, Response response) throws IOException {
        return this.handler.handle(request, response);
    }

    public void post(Runnable runnable) {
        this.threadPool.execute(runnable);
    }

    public ResponseListener getResponseListeners() {
        return this.responseListener;
    }

    public void setResponseListener(ResponseListener listener) {
        this.responseListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int main(String[] args, InputStream in, PrintStream out) throws IOException {
        Server server = new Server(args);
        try {
            server.start();
            System.out.println("Server started.  Press <Ctrl-C> to stop.");
            Server server2 = server;
            synchronized (server2) {
                server.wait();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"Server Interupted.");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Server server = new Server(args);
        try {
            server.start();
            System.out.println("Server started.  Press <Ctrl-C> to stop.");
            Server server2 = server;
            synchronized (server2) {
                server.wait();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"Server Interupted.");
        }
    }

    protected void processArguments(String[] args, Properties props) throws IOException {
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].equalsIgnoreCase("-config")) {
                if (i + 1 < args.length) {
                    this.loadConfiguration(args[i + 1], props);
                    continue;
                }
                throw new IOException("-config parameter must be followed by a config file.");
            }
            if (!args[i].startsWith("-")) continue;
            props.setProperty(args[i].substring(1), args[i + 1]);
        }
        Server.setDefaultProperties(props);
        this.setupLogging(props);
    }

    private void setupLogging(Properties props) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        props.store(stream, "");
        ByteArrayInputStream bais = new ByteArrayInputStream(stream.toByteArray());
        LogManager.getLogManager().readConfiguration(bais);
    }

    private static void setDefaultProperties(Properties props) {
        Server.setDefaultProperty(props, "mime.html", "text/html");
        Server.setDefaultProperty(props, "mime.zip", "application/x-zip-compressed");
        Server.setDefaultProperty(props, "mime.gif", "image/gif");
        Server.setDefaultProperty(props, "mime.jpeg", "image/jpeg");
        Server.setDefaultProperty(props, "mime.jpg", "image/jpeg");
        Server.setDefaultProperty(props, "mime.png", "image/png");
        Server.setDefaultProperty(props, "mime.css", "text/css");
        Server.setDefaultProperty(props, "http.port", "8082");
        Server.setDefaultProperty(props, "mime.js", "application/x-javascript");
        Server.setDefaultProperty(props, "mime.action", "text/html");
        Server.setDefaultProperty(props, "endpoints", "http");
        Server.setDefaultProperty(props, "http.class", "com.ds.server.httpproxy.core.ServerSocketEndPoint");
        Server.setDefaultProperty(props, "handler", "chain");
        Server.setDefaultProperty(props, "chain.class", "com.ds.server.httpproxy.handler.DefaultChainHandler");
        Server.setDefaultProperty(props, "chain.chain", "root,action");
        Server.setDefaultProperty(props, "root.class", "com.ds.server.httpproxy.handler.ResourceHandler");
        Server.setDefaultProperty(props, "root.urlPrefix", "/");
        Server.setDefaultProperty(props, "root.resourceMount", "/");
        Server.setDefaultProperty(props, "action.class", "com.ds.server.httpproxy.handler.UrlProxyHandler");
        Server.setDefaultProperty(props, "action.urlPrefix", "/");
        Server.setDefaultProperty(props, "action.rule", ".*\\.(action|do|ajax|jsp)(|\\?.*)");
        Server.setDefaultProperty(props, "action.subst", ".action");
    }

    private static void setDefaultProperty(Properties props, String key, String value) {
        if (props.getProperty(key) == null) {
            props.setProperty(key, value);
        }
    }

    protected void loadConfiguration(String config, Properties props) throws IOException {
        InputStream is = this.openInputStream(config);
        props.load(is);
        is.close();
    }

    private InputStream openInputStream(String config) throws FileNotFoundException {
        InputStream is;
        block2: {
            try {
                is = new FileInputStream(config);
            }
            catch (FileNotFoundException e) {
                is = Server.class.getResourceAsStream("/" + config);
                if (is != null) break block2;
                throw e;
            }
        }
        return is;
    }

    private String getLocalIp() {
        String localIp = "127.0.0.1";
        try {
            localIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return localIp;
    }

    public HashMap<String, Map> getSession() {
        return this.session;
    }

    public void setSession(HashMap session) {
        this.session = session;
    }
}

