/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import com.ds.server.httpproxy.core.Http;
import com.ds.server.httpproxy.core.HttpHeaders;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.InternetOutputStream;
import com.ds.server.httpproxy.core.Response;
import com.ds.server.httpproxy.core.ResponseDataList;
import com.ds.server.httpproxy.core.ResponseListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.impl.cookie.BasicClientCookie;

public class HttpResponse
extends Response {
    private int statusCode = 200;
    private String mimeType = "text/html";
    private HttpHeaders responseHeaders;
    private InternetOutputStream stream;
    private ResponseDataList dataStreamList;
    private HttpRequest request;
    private Map<String, BasicClientCookie> cookieMap = new HashMap<String, BasicClientCookie>();
    private boolean keepConnectionOpen;
    private ResponseListener responseListener;

    public HttpResponse(HttpRequest request, OutputStream aStream) {
        this(request, aStream, null);
    }

    public HttpResponse(HttpRequest request, OutputStream aStream, ResponseListener listener) {
        this.stream = new InternetOutputStream(aStream);
        this.request = request;
        this.dataStreamList = new ResponseDataList();
        this.responseHeaders = new HttpHeaders();
        this.keepConnectionOpen = request.isKeepAlive();
        this.responseListener = listener;
    }

    public boolean isKeepAlive() {
        return this.keepConnectionOpen && this.request.isKeepAlive();
    }

    public void addHeader(String key, String value) {
        this.responseHeaders.put(key, value);
    }

    public BasicClientCookie addCookie(String key, String value) {
        BasicClientCookie clientCookie = this.cookieMap.get(key);
        if (clientCookie == null) {
            clientCookie = new BasicClientCookie(key, value);
            this.cookieMap.put(key, clientCookie);
        } else {
            clientCookie.setValue(value);
        }
        return clientCookie;
    }

    public BasicClientCookie getCookie(String key) {
        BasicClientCookie clientCookie = this.cookieMap.get(key);
        return clientCookie;
    }

    public PrintWriter getPrintWriter() {
        return this.dataStreamList.addPrintWriter();
    }

    public void setMimeType(String aMimeType) {
        this.mimeType = aMimeType;
    }

    public void sendError(int statusCode, String errorMessage) {
        this.sendError(statusCode, errorMessage, null);
    }

    public void sendError(int statusCode, String errorMessage, Exception e) {
        this.keepConnectionOpen = false;
        if (errorMessage == null) {
            errorMessage = "";
        }
        String body = "<html>\n<head>\n<title>Error: " + statusCode + "</title>\n<body>\n<h1>" + statusCode + " <b>" + Http.getStatusPhrase(statusCode) + "</b></h1><br>\nThe requested URL <b>" + (this.request.getUrl() == null ? "<i>unknown URL</i>" : Http.encodeHtml(this.request.getUrl())) + "</b>\n " + Http.encodeHtml(errorMessage) + "\n<hr>";
        if (e != null) {
            StringWriter writer = new StringWriter();
            writer.write("<pre>");
            e.printStackTrace(new PrintWriter(writer));
            writer.write("</pre>");
            body = body + writer.toString();
        }
        body = body + "</body>\n</html>";
        this.dataStreamList.reset();
        this.statusCode = statusCode;
        this.mimeType = "text/html";
        PrintWriter out = this.getPrintWriter();
        out.write(body);
    }

    public void sendJSONResponse(String body) {
        this.sendResponse(body, "application/json;charset=UTF-8");
    }

    public void sendResponse(String body, String mimeType) {
        if (mimeType != null) {
            this.mimeType = mimeType;
        }
        ByteArrayInputStream input = new ByteArrayInputStream(body.getBytes(Charset.forName("utf-8")));
        try {
            this.sendResponse(input, body.getBytes(Charset.forName("utf-8")).length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendResponse(String body) {
        this.mimeType = "text/html";
        PrintWriter out = this.getPrintWriter();
        out.write(body);
    }

    public void sendResponse(InputStream is, int length) throws IOException {
        this.dataStreamList.addResponse(is, length);
    }

    public void sendResponse(InputStream is, long beginning, long ending) throws IOException {
        this.dataStreamList.addResponse(is, beginning, ending - beginning);
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void commitResponse() throws IOException {
        try {
            this.startTransfer();
            this.sendHttpReply(this.statusCode);
            this.sendHeaders(this.mimeType, this.dataStreamList.getTotalLength());
            if (!this.isHeadMethod()) {
                this.sendBody();
            }
            this.endTransfer();
        }
        catch (IOException e) {
            this.endTransfer(e);
            throw e;
        }
    }

    private void sendBody() throws IOException {
        this.dataStreamList.sendData(this.stream, !this.request.isProtocolVersionLessThan(1, 1));
    }

    private void sendHttpReply(int code) throws IOException {
        StringBuffer buffer = new StringBuffer(this.request.getProtocol());
        buffer.append(" ");
        buffer.append(code);
        buffer.append(" ");
        buffer.append(Http.getStatusPhrase(code));
        buffer.append("\r\n");
        this.stream.write(buffer.toString().getBytes());
    }

    private void sendHeaders(String mimeType, long contentLength) throws IOException {
        this.responseHeaders.put("Date", Http.getCurrentTime());
        this.responseHeaders.put("Server", "JDS");
        if (this.isKeepAlive()) {
            this.responseHeaders.put("Keep-Alive", "timeout=200");
            if (contentLength >= 0L) {
                this.responseHeaders.put("age", "3600");
                this.responseHeaders.put("Content-Length", Long.toString(contentLength));
            } else if (!this.request.isProtocolVersionLessThan(1, 1)) {
                this.responseHeaders.put("Transfer-Encoding", "chunked");
            }
        } else {
            this.responseHeaders.put(this.request.getConnectionHeader(), "close");
        }
        if (this.cookieMap != null && !this.cookieMap.isEmpty()) {
            ArrayList<String> cookies = new ArrayList<String>();
            Collection<BasicClientCookie> cookieCollection = this.cookieMap.values();
            for (BasicClientCookie clientCookie : cookieCollection) {
                String str = clientCookie.getName() + "=" + clientCookie.getValue();
                if (clientCookie.getPath() != null) {
                    str = str + "; Path=" + clientCookie.getPath();
                }
                if (clientCookie.getDomain() != null) {
                    str = str + "; Domain=" + clientCookie.getPath();
                }
                if (clientCookie.getExpiryDate() != null) {
                    str = str + "; Date=" + clientCookie.getExpiryDate().getTime();
                }
                cookies.add(str);
            }
            this.responseHeaders.put("Set-Cookie", cookies);
        }
        if (mimeType != null) {
            this.responseHeaders.put("Content-Type", mimeType);
        }
        this.responseHeaders.print(this.stream);
    }

    private boolean isHeadMethod() {
        return "HEAD".equalsIgnoreCase(this.request.getMethod());
    }

    public OutputStream getOutputStream() {
        return this.stream;
    }

    protected void startTransfer() {
        if (this.responseListener != null) {
            this.responseListener.startTransfer(this.request);
        }
    }

    protected void notifyListeners(int bytesSent, int length) throws IOException {
        if (this.responseListener != null) {
            this.responseListener.notify(this.request, bytesSent, length);
        }
    }

    protected void endTransfer() {
        this.endTransfer(null);
    }

    protected void endTransfer(Exception e) {
        if (this.responseListener != null) {
            this.responseListener.endTransfer(this.request, e);
        }
    }
}

