/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import com.ds.common.util.IOUtility;
import com.ds.jds.core.esb.util.ActionContext;
import com.ds.jds.core.esb.util.JDSConverter;
import com.ds.jds.core.esb.util.OgnlValueStack;
import com.ds.server.httpproxy.core.HttpHeaders;
import com.ds.server.httpproxy.core.HttpProtocolException;
import com.ds.server.httpproxy.core.InternetInputStream;
import com.ds.server.httpproxy.core.Request;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import ognl.ClassResolver;
import ognl.OgnlContext;
import ognl.OgnlRuntime;
import ognl.TypeConverter;

public class HttpRequest
extends Request {
    private static int nextRequestId = 0;
    private static final String DEFAULT_UDPCODE = "utf-8";
    private Integer requestId = null;
    private String scheme;
    private String method;
    private Map session;
    private String url;
    private String query;
    private String protocol;
    private int major;
    private OgnlContext context;
    private int minor;
    private HttpHeaders headers;
    private byte[] postData;
    private Map httpVariableMap;
    private String connectionHeader;
    private long timeStamp;
    Map<String, String> cookieMap;

    public HttpRequest(String aScheme, Socket aConnection, Properties serverConfig) {
        super(aConnection, serverConfig);
        this.scheme = aScheme;
        this.connection = aConnection;
        this.init();
    }

    public HttpRequest(String url, Properties serverConfig, boolean isInternal) {
        super(null, serverConfig);
        this.init();
        this.method = "GET";
        this.scheme = "http";
        this.parseUrl(url);
        this.protocol = "HTTP/1.0";
        this.major = 1;
        this.minor = 0;
        this.headers = new HttpHeaders();
        this.setIsInternal(isInternal);
    }

    public FileInputStream readStream(InputStream aStream) throws IOException {
        InternetInputStream stream = new InternetInputStream(aStream);
        String startLine = null;
        File file = Files.createTempFile(String.valueOf(System.currentTimeMillis()), "temp", new FileAttribute[0]).toFile();
        try {
            startLine = this.readHttpCommand(stream);
            if (startLine == null) {
                return null;
            }
            if (this.protocol.equals("HTTP/1.0")) {
                this.major = 1;
                this.minor = 0;
            } else if (this.protocol.equals("HTTP/1.1")) {
                this.major = 1;
                this.minor = 1;
            } else {
                throw new HttpProtocolException(505, "Protocol " + this.protocol + " not supported.");
            }
            this.headers = new HttpHeaders(stream);
            FileOutputStream output = new FileOutputStream(file);
            IOUtility.copy((InputStream)stream, (OutputStream)output);
            IOUtility.shutdownStream((OutputStream)output);
        }
        catch (NoSuchElementException e) {
            throw new HttpProtocolException(404, "Bad request " + startLine);
        }
        catch (NumberFormatException e) {
            throw new HttpProtocolException(411, "Content Length was not a number or not supplied.");
        }
        return new FileInputStream(file);
    }

    public boolean readRequest(InputStream aStream) throws IOException {
        InternetInputStream stream = new InternetInputStream(aStream);
        String startLine = null;
        try {
            startLine = this.readHttpCommand(stream);
            if (startLine == null) {
                return false;
            }
            if (this.protocol.equals("HTTP/1.0")) {
                this.major = 1;
                this.minor = 0;
            } else if (this.protocol.equals("HTTP/1.1")) {
                this.major = 1;
                this.minor = 1;
            } else {
                throw new HttpProtocolException(505, "Protocol " + this.protocol + " not supported.");
            }
            this.headers = new HttpHeaders(stream);
            this.readPostData(stream);
        }
        catch (NoSuchElementException e) {
            throw new HttpProtocolException(404, "Bad request " + startLine);
        }
        catch (NumberFormatException e) {
            throw new HttpProtocolException(411, "Content Length was not a number or not supplied.");
        }
        return true;
    }

    private void init() {
        this.method = null;
        this.url = null;
        this.query = null;
        this.protocol = null;
        this.connectionHeader = null;
        this.postData = null;
        this.httpVariableMap = null;
        this.timeStamp = System.currentTimeMillis();
        this.connectionHeader = "Connection";
        this.requestId = new Integer(nextRequestId++);
    }

    public Integer getRequestId() {
        return this.requestId;
    }

    private String readHttpCommand(InternetInputStream stream) throws IOException {
        String startLine = null;
        do {
            if ((startLine = stream.readline()) != null) continue;
            return null;
        } while (startLine.trim().length() == 0);
        StringTokenizer tokenizer = new StringTokenizer(startLine);
        this.method = tokenizer.nextToken();
        this.parseUrl(tokenizer.nextToken());
        this.protocol = tokenizer.nextToken();
        return startLine;
    }

    public Map<String, String> getCookie() {
        Object cookieObj;
        if (this.cookieMap == null) {
            this.cookieMap = new HashMap<String, String>();
        }
        if ((cookieObj = this.getHeaders().get("Cookie")) != null) {
            String cookieStr = cookieObj.toString();
            if (cookieStr.toString().indexOf(";") > -1) {
                String[] cookies;
                for (String cookie : cookies = cookieStr.split(";")) {
                    if (cookie.indexOf("=") <= -1) continue;
                    String[] keyVlaue = cookie.split("=");
                    this.cookieMap.put(keyVlaue[0].trim().toUpperCase(), keyVlaue[1].trim());
                }
            } else if (cookieStr.indexOf("=") > -1) {
                String[] keyVlaue = cookieStr.split("=");
                this.cookieMap.put(keyVlaue[0].trim().toUpperCase(), keyVlaue[1].trim());
            }
        }
        return this.cookieMap;
    }

    private void readPostData(InternetInputStream stream) throws IOException {
        String contenLength = this.getRequestHeader("Content-Length");
        if (contenLength == null) {
            return;
        }
        int postLength = Integer.parseInt(contenLength);
        this.postData = new byte[postLength];
        int length = -1;
        for (int offset = stream.read(this.postData); offset >= 0 && offset < this.postData.length && (length = stream.read(this.postData, offset, this.postData.length - offset)) != -1; offset += length) {
        }
    }

    public void parseUrl(String aUrl) {
        int queryIndex = aUrl.indexOf(63);
        if (queryIndex < 0) {
            this.url = aUrl;
        } else {
            this.url = aUrl.substring(0, queryIndex);
            if (queryIndex + 1 < aUrl.length()) {
                this.query = aUrl.substring(queryIndex + 1);
            }
        }
    }

    public String getRequestHeader(String key) {
        if (this.headers.get(key) != null) {
            return this.headers.get(key).toString();
        }
        return null;
    }

    public String getRequestHeader(String key, String defaultValue) {
        String val = this.getRequestHeader(key);
        return val == null ? defaultValue : val.toString();
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public String getQuery() {
        return this.query;
    }

    public String getContentType() {
        String contentType = this.getRequestHeader("Content-Type");
        if (contentType == null) {
            contentType = this.getRequestHeader("Content-type");
        }
        return contentType;
    }

    public Map getParameterMap() {
        if (this.httpVariableMap == null) {
            String contentType;
            this.httpVariableMap = this.createQueryMap(this.query);
            if (this.postData != null && (contentType = this.getContentType()) != null && contentType.indexOf("multipart/form-data") == -1 && contentType.indexOf("application/json") == -1) {
                this.httpVariableMap.putAll(this.createQueryMap(new String(this.postData)));
            }
        }
        return this.httpVariableMap;
    }

    public OgnlContext getOgnlContext() {
        if (this.context == null) {
            OgnlValueStack valueStack = (OgnlValueStack)ActionContext.getContext().getValueStack();
            HashMap valueMap = new HashMap();
            if (this.httpVariableMap != null) {
                valueMap.putAll(this.httpVariableMap);
            }
            if (this.session != null) {
                valueMap.putAll(this.session);
            }
            OgnlRuntime.clearCache();
            this.context = new OgnlContext((ClassResolver)OgnlValueStack.getAccessor(), (TypeConverter)JDSConverter.getInstance(), null, valueMap);
        }
        return this.context;
    }

    public String getPath() {
        String path = this.getUrl();
        try {
            URL url = new URL(this.getUrl());
            path = url.getPath();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return path;
    }

    public String getParameter(String key) {
        this.httpVariableMap = this.getParameterMap();
        return (String)this.httpVariableMap.get(key);
    }

    public Set getParameterNames() {
        return this.getParameterMap().keySet();
    }

    public Map createQueryMap(String query) {
        TreeMap<String, String> queryMap = new TreeMap<String, String>();
        if (query == null) {
            return queryMap;
        }
        query = query.replace('+', ' ');
        StringTokenizer st = new StringTokenizer(query, "&");
        try {
            while (st.hasMoreTokens()) {
                String field = st.nextToken();
                int index = field.indexOf(61);
                if (index < 0) {
                    queryMap.put(URLDecoder.decode(field, DEFAULT_UDPCODE), "");
                    continue;
                }
                queryMap.put(URLDecoder.decode(field.substring(0, index), DEFAULT_UDPCODE), URLDecoder.decode(field.substring(index + 1), DEFAULT_UDPCODE));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return queryMap;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public byte[] getPostData() {
        return this.postData;
    }

    public boolean isKeepAlive() {
        if ("Keep-Alive".equalsIgnoreCase(this.getRequestHeader(this.connectionHeader))) {
            return true;
        }
        if ("close".equalsIgnoreCase(this.getRequestHeader(this.connectionHeader))) {
            return false;
        }
        return this.major >= 1 && this.minor > 0;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public String getConnectionHeader() {
        return this.connectionHeader;
    }

    public long getTimestamp() {
        return this.timeStamp;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public String toString() {
        return this.method + " " + this.url + (this.query != null ? "?" + this.query : "") + " " + this.protocol;
    }

    public String serverUrl() {
        return this.getProperty("url");
    }

    public String createUrl(String absolutePath) throws IOException {
        return absolutePath;
    }

    public boolean isProtocolVersionLessThan(int aMajor, int aMinor) {
        return this.major <= aMajor && this.minor < aMinor;
    }

    public Map getSession() {
        return this.session;
    }

    public void setSession(Map session) {
        this.session = session;
    }
}

