/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import com.ds.server.httpproxy.core.InternetInputStream;
import com.ds.server.httpproxy.core.InternetOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HttpHeaders {
    private Map map = new LinkedHashMap();

    public HttpHeaders() {
    }

    public Map toMap() {
        return this.map;
    }

    public HttpHeaders(InternetInputStream stream) throws IOException {
        this();
        String line;
        String currentKey = null;
        while ((line = stream.readline()) != null && line.length() != 0) {
            if (!Character.isSpaceChar(line.charAt(0))) {
                int index = line.indexOf(58);
                if (index < 0) continue;
                currentKey = line.substring(0, index).trim();
                String value = line.substring(index + 1).trim();
                this.put(currentKey, value);
                continue;
            }
            if (currentKey == null) continue;
            Object value = this.get(currentKey);
            this.put(currentKey, value + "\r\n\t" + line.trim());
        }
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public Object get(String key, String defaultValue) {
        Object value = this.get(key);
        return value == null ? defaultValue : value;
    }

    public void put(String key, Object value) {
        this.map.put(key, value);
    }

    public boolean contains(String headerKey) {
        return this.map.containsKey(headerKey);
    }

    public void clear() {
        this.map.clear();
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public void print(InternetOutputStream stream) throws IOException {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (this.get(key) instanceof List) {
                List objs = (List)this.get(key);
                for (Object obj : objs) {
                    stream.println(key + ": " + obj.toString());
                }
                continue;
            }
            stream.println(key + ": " + this.get(key));
        }
        stream.println();
        stream.flush();
    }
}

