/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.security.PermissionCollection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;

public class Http {
    private static HashMap codesMap = new HashMap();
    private static HashMap htmlCharacterEncodings = new HashMap();
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    public static final String CRLF = "\r\n";

    public static String getStatusPhrase(int code) {
        String phrase = (String)codesMap.get(new Integer(code));
        if (phrase == null) {
            return "Error";
        }
        return phrase;
    }

    public static String encodeHtml(String message) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < message.length(); ++i) {
            String tmp = Character.toString(message.charAt(i));
            if (htmlCharacterEncodings.containsKey(tmp)) {
                result.append("&");
                result.append(htmlCharacterEncodings.get(tmp));
                result.append(";");
                continue;
            }
            result.append(tmp);
        }
        return result.toString();
    }

    public static String getCurrentTime() {
        return Http.formatTime(System.currentTimeMillis());
    }

    public static String formatTime(long time) {
        return dateFormat.format(new Date(time)).substring(0, 29);
    }

    public static long parseTime(String date) throws ParseException {
        return dateFormat.parse(date).getTime();
    }

    public static String join(String path, String relativePath) {
        boolean pathEnds = path.endsWith("/");
        boolean relativeStarts = relativePath.startsWith("/");
        if (pathEnds && !relativeStarts || !relativeStarts && pathEnds) {
            return path + relativePath;
        }
        if (pathEnds && relativeStarts) {
            return path + relativePath.substring(1);
        }
        return path + "/" + relativePath;
    }

    public static File translatePath(String root, String url) throws UnsupportedEncodingException {
        String name = URLDecoder.decode(url, "UTF-8");
        name = name.replace('/', File.separatorChar);
        File file = new File(root, name);
        return file;
    }

    public static boolean isSecure(String root, File file) throws IOException {
        PermissionCollection rootDirectory;
        if (root.endsWith(File.separator)) {
            FilePermission fp = new FilePermission(root + "-", "read");
            rootDirectory = fp.newPermissionCollection();
            rootDirectory.add(fp);
            rootDirectory.add(new FilePermission(root.substring(0, root.length() - 1), "read"));
        } else {
            FilePermission fp = new FilePermission(root, "read");
            rootDirectory = fp.newPermissionCollection();
            rootDirectory.add(fp);
            rootDirectory.add(new FilePermission(root + File.separator + "-", "read"));
        }
        return rootDirectory.implies(new FilePermission(file.getCanonicalPath(), "read"));
    }

    public static InetAddress findRoutableHostAddress() throws UnknownHostException, SocketException {
        InetAddress localAddress = InetAddress.getLocalHost();
        if (localAddress.isSiteLocalAddress() || localAddress.isLoopbackAddress()) {
            Enumeration<NetworkInterface> networkEnum = NetworkInterface.getNetworkInterfaces();
            while (networkEnum.hasMoreElements()) {
                NetworkInterface netInterface = networkEnum.nextElement();
                Enumeration<InetAddress> inetAddressEnum = netInterface.getInetAddresses();
                while (inetAddressEnum.hasMoreElements()) {
                    InetAddress address = inetAddressEnum.nextElement();
                    if (address.isSiteLocalAddress() || address.isLoopbackAddress()) continue;
                    return address;
                }
            }
        }
        return localAddress;
    }

    public static List findAllHostAddresses(boolean includeLoopback) throws SocketException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> networkEnum = NetworkInterface.getNetworkInterfaces();
        while (networkEnum.hasMoreElements()) {
            NetworkInterface netInterface = networkEnum.nextElement();
            Enumeration<InetAddress> inetAddressEnum = netInterface.getInetAddresses();
            while (inetAddressEnum.hasMoreElements()) {
                InetAddress address = inetAddressEnum.nextElement();
                if (!includeLoopback && address.isLoopbackAddress()) continue;
                addresses.add(address);
            }
        }
        return addresses;
    }

    static {
        dateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        dateFormat.setLenient(true);
        htmlCharacterEncodings.put("&", "amp");
        htmlCharacterEncodings.put("<", "lt");
        htmlCharacterEncodings.put(">", "gt");
        htmlCharacterEncodings.put("\"", "quot");
        htmlCharacterEncodings.put("'", "apos");
        codesMap.put(new Integer(100), "Continue");
        codesMap.put(new Integer(101), "Switching Protocols");
        codesMap.put(new Integer(200), "OK");
        codesMap.put(new Integer(201), "Created");
        codesMap.put(new Integer(202), "Accepted");
        codesMap.put(new Integer(203), "Non-Authoritative Information");
        codesMap.put(new Integer(204), "No Content");
        codesMap.put(new Integer(205), "Reset Content");
        codesMap.put(new Integer(206), "Partial Content");
        codesMap.put(new Integer(300), "Multiple Choices");
        codesMap.put(new Integer(301), "Moved Permanently");
        codesMap.put(new Integer(302), "Moved Temporarily");
        codesMap.put(new Integer(303), "See Other");
        codesMap.put(new Integer(304), "Not Modified");
        codesMap.put(new Integer(305), "Use Proxy");
        codesMap.put(new Integer(400), "Bad Request");
        codesMap.put(new Integer(401), "Unauthorized");
        codesMap.put(new Integer(402), "Payment Required");
        codesMap.put(new Integer(403), "Forbidden");
        codesMap.put(new Integer(404), "Not Found");
        codesMap.put(new Integer(405), "Method Not Allowed");
        codesMap.put(new Integer(406), "Not Acceptable");
        codesMap.put(new Integer(407), "Proxy Authentication Required");
        codesMap.put(new Integer(408), "Request Time-out");
        codesMap.put(new Integer(409), "Conflict");
        codesMap.put(new Integer(410), "Gone");
        codesMap.put(new Integer(411), "Length Required");
        codesMap.put(new Integer(412), "Precondition Failed");
        codesMap.put(new Integer(413), "Request Entity Too Large");
        codesMap.put(new Integer(414), "Request-URI Too Large");
        codesMap.put(new Integer(415), "Unsupported Media Type");
        codesMap.put(new Integer(500), "Server Error");
        codesMap.put(new Integer(501), "Not Implemented");
        codesMap.put(new Integer(502), "Bad Gateway");
        codesMap.put(new Integer(503), "Service Unavailable");
        codesMap.put(new Integer(504), "Gateway Time-out");
        codesMap.put(new Integer(505), "HTTP Version not supported");
    }
}

