/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.context.JDSActionContext;
import com.ds.server.context.MinServerActionContextImpl;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;

public class ConnectionRunnable
implements Runnable {
    private static final Log log = LogFactory.getLog((String)"JDS", ConnectionRunnable.class);
    protected Server server;
    protected Socket connection;
    protected Properties config;
    protected String scheme;

    public ConnectionRunnable(Server aServer, String aScheme, Socket aConnection, Properties aConnectionConfig) {
        this.scheme = aScheme;
        this.server = aServer;
        this.connection = aConnection;
        this.config = aConnectionConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean next = false;
            HttpRequest request = this.createRequest();
            JDSActionContext.getActionContext().remove();
            JDSActionContext.setContext(new MinServerActionContextImpl(request, request.getOgnlContext()));
            do {
                if (!this.connection.isClosed() && request.readRequest(this.connection.getInputStream())) {
                    HttpResponse response = new HttpResponse(request, this.connection.getOutputStream(), this.server.getResponseListeners());
                    if (!this.server.post(request, response)) {
                        response.sendError(404, " was not found on this server.");
                    }
                    if (!(next = response.isKeepAlive())) {
                        response.addHeader("Connection", "close");
                    }
                    response.commitResponse();
                    continue;
                }
                next = false;
            } while (next);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn((Object)"Handler threw an exception.", (Throwable)e);
        }
        finally {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected HttpRequest createRequest() throws IOException {
        return new HttpRequest(this.scheme, this.connection, this.config);
    }
}

