/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import com.ds.server.httpproxy.core.Server;

public class ConfigOption {
    String propertyName;
    String defaultValue;
    boolean isRequired;
    String helpString;

    public ConfigOption(String propertyName, String helpString) {
        this(propertyName, false, helpString);
    }

    public ConfigOption(String propertyName, String defaultValue, String helpString) {
        this.propertyName = propertyName;
        this.defaultValue = defaultValue;
        this.isRequired = false;
        this.helpString = helpString;
    }

    public ConfigOption(String propertyName, boolean required, String helpString) {
        this.propertyName = propertyName;
        this.defaultValue = null;
        this.isRequired = required;
        this.helpString = helpString;
    }

    public String getProperty(Server server, String name) {
        String key = this.propertyName;
        if (name != null) {
            key = name + "." + key;
        }
        String value = server.getProperty(key, this.defaultValue);
        if (this.isRequired && value == null) {
            throw new IllegalArgumentException(key + " is a required argument.");
        }
        return value.trim();
    }

    public Boolean getBoolean(Server server, String name) {
        return new Boolean(this.getProperty(server, name));
    }

    public Integer getInteger(Server server, String name) {
        return new Integer(this.getProperty(server, name));
    }

    public String toHelp() {
        return this.propertyName + "\t" + (this.isRequired ? "Required" : "Optional") + "\t" + this.defaultValue + "\t" + this.helpString;
    }

    public String getName() {
        return this.propertyName;
    }
}

