/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedEncodingOutputStream
extends FilterOutputStream {
    static final int DEFAULT_CHUNK_SIZE = 4096;
    byte[] buf = null;
    int count = 0;

    public ChunkedEncodingOutputStream(OutputStream out, int maxChunkSize) {
        super(out);
        this.buf = new byte[maxChunkSize];
    }

    public ChunkedEncodingOutputStream(OutputStream out) {
        this(out, 4096);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flush();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < len; ++i) {
            if (this.count >= this.buf.length) {
                this.flush();
            }
            this.buf[this.count++] = b[i];
        }
    }

    @Override
    public void flush() throws IOException {
        this.writeChunkSize(this.count);
        this.writeChunkData(this.buf, this.count);
        this.count = 0;
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.count > 0) {
            this.flush();
        }
        this.writeChunkEnding();
        this.out.close();
    }

    private void writeChunkSize(int count) throws IOException {
        if (count > 0) {
            this.out.write(Integer.toHexString(count).getBytes());
            this.out.write("\r\n".getBytes());
        }
    }

    private void writeChunkData(byte[] buf, int count) throws IOException {
        if (count > 0) {
            this.out.write(buf, 0, count);
            this.out.write("\r\n".getBytes());
        }
    }

    private void writeChunkEnding() throws IOException {
        this.out.write("0".getBytes());
        this.out.write("\r\n".getBytes());
        this.out.write("\r\n".getBytes());
    }
}

