/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ChainableProperties
extends Properties {
    Properties parent;

    public ChainableProperties() {
        this.parent = null;
    }

    public ChainableProperties(Properties parent) {
        this.parent = parent;
    }

    public Properties getParent() {
        return this.parent;
    }

    @Override
    public String getProperty(String key) {
        String value = super.getProperty(key);
        if (value == null && this.parent != null) {
            value = this.parent.getProperty(key);
        }
        value = this.resolveVariables(value, null);
        return value;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = super.getProperty(key, defaultValue);
        if (value == null && this.parent != null) {
            value = this.parent.getProperty(key, defaultValue);
        }
        value = this.resolveVariables(value, defaultValue);
        return value;
    }

    private String resolveVariables(String value, String defaultValue) {
        if (value != null) {
            int start = value.indexOf("${");
            StringBuffer buf = new StringBuffer(value.substring(0, start >= 0 ? start : value.length()));
            while (start >= 0) {
                int end = value.indexOf(125, start);
                String tmp = this.getProperty(value.substring(start + 2, end), defaultValue);
                if (tmp != null) {
                    buf.append(tmp);
                } else {
                    buf.append(value.substring(start, end + 1));
                }
                start = value.indexOf("${", end);
                buf.append(value.substring(end + 1, start >= 0 ? start : value.length()));
            }
            return buf.toString();
        }
        return defaultValue;
    }

    public Enumeration propertyNames() {
        Vector<Object> set = new Vector<Object>(this.parent.keySet());
        set.addAll(super.keySet());
        return set.elements();
    }

    @Override
    public synchronized Object get(Object key) {
        Object value = super.get(key);
        if (value == null && this.parent != null) {
            value = this.parent.get(key);
        }
        return value;
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        boolean contains = super.containsKey(key);
        if (!contains && this.parent != null) {
            contains = this.parent.containsKey(key);
        }
        return contains;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean contains = super.containsValue(value);
        if (!contains && this.parent != null) {
            contains = this.parent.containsValue(value);
        }
        return contains;
    }

    @Override
    public synchronized boolean contains(Object value) {
        boolean contains = super.contains(value);
        if (!contains && this.parent != null) {
            contains = this.parent.contains(value);
        }
        return contains;
    }

    @Override
    public void list(PrintStream out) {
        super.list(out);
        this.parent.list(out);
    }

    @Override
    public void list(PrintWriter out) {
        super.list(out);
        this.parent.list(out);
    }
}

