/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.util.TypeUtils;
import com.ds.annotation.Aggregation;
import com.ds.annotation.RequestType;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.common.util.IOUtility;
import com.ds.common.util.StringUtility;
import com.ds.config.JDSUtil;
import com.ds.context.JDSActionContext;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.jds.core.esb.util.ActionContext;
import com.ds.server.context.MinServerActionContextImpl;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.Handler;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Request;
import com.ds.server.httpproxy.core.Response;
import com.ds.server.httpproxy.core.Server;
import com.ds.server.httpproxy.core.UUID;
import com.ds.server.httpproxy.handler.multipart.CommonsMultipartFile;
import com.ds.server.httpproxy.handler.multipart.SimpleRequestContext;
import com.ds.template.JDSFreemarkerResult;
import com.ds.web.APIConfigFactory;
import com.ds.web.BaseParamsEnums;
import com.ds.web.RequestMethodBean;
import com.ds.web.RequestParamBean;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractHandler
implements Handler {
    public static final Log logger = LogFactory.getLog((String)"JDS", AbstractHandler.class);
    protected Server server;
    protected String handlerName;
    protected String urlPrefix;
    private HashMap contextMap;
    private OgnlContext ognlContext;
    public static final ConfigOption RESOURCE_MOUNT_OPTION = new ConfigOption("resourceMount", "/", "A path within the classpath to the root of the folder to share.");
    public static final ConfigOption DEFAULT_RESOURCE_OPTION = new ConfigOption("default", "index.html", "The default resource name.");
    public static final ConfigOption RULE_OPTION = new ConfigOption("rule", true, "Regular expression for matching URLs.");
    public static final ConfigOption URL_PREFIX_OPTION = new ConfigOption("url-prefix", "/", "URL prefix path for this handler.  Anything that matches starts with this prefix will be handled by this handler.");

    @Override
    public boolean initialize(String handlerName, Server server) {
        this.server = server;
        this.handlerName = handlerName;
        this.urlPrefix = URL_PREFIX_OPTION.getProperty(server, handlerName);
        return true;
    }

    @Override
    public String getName() {
        return this.handlerName;
    }

    @Override
    public boolean handle(Request aRequest, Response aResponse) throws IOException {
        if (aRequest instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)aRequest;
            HttpResponse response = (HttpResponse)aResponse;
            String mimeType = this.getMimeType(request.getPath());
            if (mimeType == null || mimeType.startsWith("text/html") || request.getPath().endsWith(".cls")) {
                int queryIndex;
                MinServerActionContextImpl context = (MinServerActionContextImpl)JDSActionContext.getActionContext();
                context.setHandle(this);
                context.setHttpRequest(request);
                context.setHttpResponse(aResponse);
                String sessionId = null;
                sessionId = request.getParameterMap().containsKey("JSESSIONID") ? request.getParameterMap().get("JSESSIONID").toString() : request.getCookie().get("JSESSIONID".toUpperCase());
                if (sessionId == null) {
                    sessionId = UUID.createUUID().toString();
                }
                BasicClientCookie clientCookie = response.addCookie("JSESSIONID", sessionId);
                clientCookie.setPath("/");
                context.getParamMap().putAll(request.getParameterMap());
                if (sessionId != null) {
                    context.setSessionId(sessionId);
                    HashMap session = this.server.getSession().get(sessionId);
                    if (session == null) {
                        session = new HashMap();
                        this.server.getSession().put(sessionId, session);
                    }
                    request.setSession(session);
                    context.getSessionMap().putAll(session);
                }
                String query = "";
                String referer = request.getRequestHeader("Referer");
                if (referer != null && (queryIndex = referer.indexOf(63)) > 0 && !referer.endsWith("?")) {
                    query = referer.substring(queryIndex + 1);
                }
                request.getParameterMap().putAll(this.createQueryMap(query));
                String sysId = this.server.getProperty("SYSID");
                if (sysId != null) {
                    context.getContext().put("SYSID", sysId);
                }
                this.ognlContext = ((HttpRequest)aRequest).getOgnlContext();
            }
            return this.handleBody(request, response);
        }
        return false;
    }

    public Object invokMethod(RequestMethodBean methodBean) {
        Object object = null;
        HttpRequest request = (HttpRequest)JDSActionContext.getActionContext().getHttpRequest();
        HttpResponse response = (HttpResponse)JDSActionContext.getActionContext().getHttpResponse();
        try {
            object = this.invokMethod(methodBean, request, response);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (OgnlException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return object;
    }

    public Object invokMethod(RequestMethodBean methodBean, HttpRequest request, HttpResponse response) throws ClassNotFoundException, OgnlException, IOException {
        Object object = null;
        Object service = this.getService(methodBean, request);
        Map<String, Object> allParamsMap = this.getAllParamMap(methodBean, request);
        Map paramsMap = methodBean.getParamsMap();
        LinkedHashSet keySet = methodBean.getParamSet();
        Object[] objects = new Object[paramsMap.size()];
        Class[] objectTyps = new Class[paramsMap.size()];
        int k = 0;
        for (RequestParamBean paramBean : keySet) {
            String key = paramBean.getParamName();
            Class ctClass = ClassUtility.loadClass((String)((String)paramsMap.get(paramBean.getParamName())));
            Class paramClass = paramBean.getParamClass();
            if (paramClass.isInterface()) {
                paramClass = EsbUtil.guessRealClass((Class)paramClass);
            }
            String iClassName = ctClass.getName();
            Class iClass = ClassUtility.loadClass((String)iClassName);
            Object value = null;
            RequestBody requestBody = null;
            for (BaseParamsEnums[] annotation : paramBean.getAnnotations()) {
                if (!annotation.annotationType().equals(RequestBody.class)) continue;
                requestBody = (RequestBody)annotation;
            }
            if (requestBody != null) {
                if (methodBean.getRequestType().equals((Object)RequestType.JSON)) {
                    JSONObject requestBodyValue = JSON.parseObject((String)new String(request.getPostData()));
                    for (BaseParamsEnums baseParams : BaseParamsEnums.values()) {
                        if (!requestBodyValue.containsKey((Object)baseParams.name())) continue;
                        JDSActionContext.getActionContext().getContext().put(baseParams.name(), requestBodyValue.get((Object)baseParams.name()));
                    }
                    value = JSONObject.parseObject((String)JSON.toJSONString((Object)requestBodyValue), (Class)paramClass);
                }
            } else if (Request.class.isAssignableFrom(iClass)) {
                value = request;
            } else if (Response.class.isAssignableFrom(iClass)) {
                value = response;
            } else {
                try {
                    switch (methodBean.getRequestType()) {
                        case FORM: {
                            if (iClass.isArray()) {
                                if (JSONObject.parseArray((String)allParamsMap.get(key).toString()).size() > 0) {
                                    value = JSONObject.parseArray((String)allParamsMap.get(key).toString(), iClass.getComponentType()).toArray();
                                    break;
                                }
                                value = Array.newInstance(iClass.getComponentType(), 0);
                                break;
                            }
                            if (paramBean.getJsonData().booleanValue()) {
                                if (iClass.isArray() || Collection.class.isAssignableFrom(iClass)) {
                                    value = JSONArray.parseObject((String)allParamsMap.get(key).toString(), (Type)paramBean.getParamType(), (Feature[])new Feature[0]);
                                    break;
                                }
                                value = JSONObject.parseObject((String)allParamsMap.get(key).toString(), (Type)paramBean.getParamType(), (Feature[])new Feature[0]);
                                break;
                            }
                            value = TypeUtils.castToJavaBean((Object)allParamsMap.get(key), (Class)iClass);
                            break;
                        }
                        case JSON: {
                            JSONObject jsonObject = JSON.parseObject((String)new String(request.getPostData()));
                            if (jsonObject != null) {
                                for (BaseParamsEnums baseParams : BaseParamsEnums.values()) {
                                    if (!jsonObject.containsKey((Object)baseParams.name())) continue;
                                    JDSActionContext.getActionContext().getContext().put(baseParams.name(), jsonObject.get((Object)baseParams.name()));
                                }
                                String paramName = paramBean.getParamName();
                                Object obj = jsonObject.get((Object)paramName);
                                if (obj != null) {
                                    value = TypeUtils.castToJavaBean((Object)obj, (Class)iClass);
                                    JDSActionContext.getActionContext().getContext().put(paramName, value);
                                }
                            }
                            break;
                        }
                        default: {
                            value = TypeUtils.cast((Object)allParamsMap.get(key), (Class)iClass, null);
                        }
                    }
                }
                catch (Throwable e) {
                    logger.error((Object)("params [" + key + "] convertValue err " + e.getMessage()));
                }
            }
            objectTyps[k] = iClass;
            objects[k] = value;
            ++k;
        }
        if (service != null) {
            object = OgnlRuntime.callMethod((OgnlContext)this.getOgnlContext(), (Object)service, (String)methodBean.getMethodName(), (Object[])objects);
        }
        return object;
    }

    public boolean sendFtl(HttpRequest request, HttpResponse response, String resource) throws IOException {
        String responseStr = "";
        try {
            JDSFreemarkerResult result = new JDSFreemarkerResult();
            StringWriter stringWriter = (StringWriter)result.doExecute(resource, null);
            responseStr = stringWriter.toString();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        response.setMimeType("text/html");
        response.sendResponse(this.getInputStream(responseStr, "utf-8"), -1);
        return true;
    }

    public boolean sendJSON(RequestMethodBean methodBean, HttpResponse response, String json) {
        Set produces = methodBean.getMappingBean().getProduces();
        StringBuffer mimeType = new StringBuffer();
        if (produces != null && produces.size() > 0) {
            for (String produce : produces) {
                mimeType.append(produce);
                mimeType.append(";");
            }
            response.sendResponse(json, mimeType.toString());
        } else {
            switch (methodBean.getResponseType()) {
                case JSON: {
                    response.sendJSONResponse(json);
                    break;
                }
                case TEXT: {
                    response.addHeader("Content-Type", "text/html");
                    response.sendResponse(json);
                    break;
                }
                case XML: {
                    response.sendResponse(json);
                    break;
                }
                default: {
                    response.sendResponse(json);
                }
            }
        }
        return true;
    }

    public Object upload(RequestMethodBean methodBean, HttpRequest request, HttpResponse response) throws IOException {
        HashMap params = new HashMap();
        Object object = null;
        LinkedHashSet paramBeanSet = methodBean.getParamSet();
        Boolean isMulti = false;
        for (RequestParamBean paramBean : paramBeanSet) {
            if (!MultipartFile.class.isAssignableFrom(paramBean.getParamClass())) continue;
            isMulti = true;
        }
        ArrayList<CommonsMultipartFile> paramObjs = new ArrayList<CommonsMultipartFile>();
        if (isMulti.booleanValue()) {
            SimpleRequestContext requestContext = new SimpleRequestContext(StandardCharsets.UTF_8, this.getContentType(request), new ByteArrayInputStream(request.getPostData()));
            PortletFileUpload fileUploadBase = new PortletFileUpload();
            DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
            fileUploadBase.setFileItemFactory((FileItemFactory)fileItemFactory);
            fileUploadBase.setHeaderEncoding("utf-8");
            List fileItems = null;
            try {
                fileItems = fileUploadBase.parseRequest((RequestContext)requestContext);
            }
            catch (FileUploadException e) {
                e.printStackTrace();
            }
            for (RequestParamBean paramBean : paramBeanSet) {
                Object obj = null;
                for (FileItem f : fileItems) {
                    if (!f.getFieldName().equals(paramBean.getParamName())) continue;
                    if (f.isFormField()) {
                        obj = new String(f.getString().getBytes("iso8859-1"), "UTF-8");
                        continue;
                    }
                    CommonsMultipartFile commonsMultipartFile = new CommonsMultipartFile(f);
                    obj = commonsMultipartFile;
                }
                paramObjs.add((CommonsMultipartFile)obj);
            }
        }
        try {
            Object service = this.getService(methodBean, request);
            object = OgnlRuntime.callMethod((OgnlContext)this.getOgnlContext(), (Object)service, (String)methodBean.getMethodName(), (Object[])paramObjs.toArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return object;
    }

    public String getProjectName(HttpRequest request) throws MalformedURLException {
        String urlStr;
        String path;
        String projectName = request.getParameter("projectVersionName");
        if (this.isNullParams(projectName)) {
            URL parenturl = null;
            if (request.getHeaders().get("Referer") != null && ((projectName = this.createQueryMap((parenturl = new URL(request.getHeaders().get("Referer").toString())).getQuery()).get("projectVersionName")) == null || projectName.equals("")) && (path = this.formatPath(parenturl.toString(), projectName)).indexOf("/") > -1) {
                projectName = path.substring(0, path.indexOf("/"));
            }
        }
        if (this.isNullParams(projectName) && (path = this.formatPath(urlStr = request.getUrl(), projectName)).indexOf("/") > -1) {
            projectName = path.substring(0, path.indexOf("/"));
        }
        if (this.isNullParams(projectName) && this.getServer().getProxyHost() != null) {
            projectName = this.getServer().getProxyHost().getProjectName();
        }
        if (projectName == null || projectName.equals("") || projectName.equals("projectManager") && request.getParameter("projectName") != null) {
            projectName = request.getParameter("projectName");
        }
        request.getParameterMap().put("projectName", projectName);
        request.getParameterMap().put("projectVersionName", projectName);
        return projectName;
    }

    public boolean isNullParams(String paramName) {
        return paramName == null || paramName.equals("") || paramName.equals("[object Object]") || paramName.equals("@{projectName}");
    }

    public String formatPath(String urlStr, String projectName) throws MalformedURLException {
        String path = urlStr;
        if (urlStr.startsWith("http")) {
            URL url = new URL(urlStr);
            path = url.getPath();
        }
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        for (String ckey : CKEY) {
            String key = ckey + "/";
            if (!path.startsWith(key)) continue;
            path = path.substring(key.length());
        }
        if (projectName != null) {
            if (projectName.indexOf("VVVERSION") > -1) {
                projectName = projectName.split("VVVERSION")[0];
            }
            if (path.startsWith(projectName + "/") || path.startsWith(projectName + "VVVERSION")) {
                path = path.substring(path.indexOf("/") + 1);
            }
        }
        return path;
    }

    public InputStream getInputStream(String content, String charSet) {
        if (content == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(content.getBytes(charSet));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Map<String, String> createQueryMap(String query) {
        TreeMap<String, String> queryMap = new TreeMap<String, String>();
        if (query == null) {
            return queryMap;
        }
        query = query.replace('+', ' ');
        StringTokenizer st = new StringTokenizer(query, "&");
        try {
            while (st.hasMoreTokens()) {
                String field = st.nextToken();
                int index = field.indexOf(61);
                if (index < 0) {
                    queryMap.put(URLDecoder.decode(field, "UTF-8"), "");
                    continue;
                }
                queryMap.put(URLDecoder.decode(field.substring(0, index), "UTF-8"), URLDecoder.decode(field.substring(index + 1), "UTF-8"));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return queryMap;
    }

    public Map<String, Object> getPathParamsValue(String methodUrl, String url) {
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        while (methodUrl.indexOf("{") > -1 && methodUrl.indexOf("}") > -1) {
            int start = methodUrl.indexOf("{");
            int end = methodUrl.indexOf("}");
            String paramName = methodUrl.substring(start, end + 1);
            methodUrl = url.substring(start);
            String value = methodUrl.substring(0, methodUrl.indexOf("/"));
            pathParams.put(paramName.substring(1, paramName.length() - 1), value);
        }
        return pathParams;
    }

    public String getExtStr(String ftl) throws IOException, TemplateException {
        StringWriter stringWriter = new StringWriter();
        Configuration configuration = new Configuration();
        try {
            String path = JDSUtil.getJdsRealPath();
            path = path + "/ftl/";
            configuration.setDirectoryForTemplateLoading(new File(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Template template = configuration.getTemplate(ftl);
        template.process((Object)this.getContextMap(), (Writer)stringWriter);
        String str = stringWriter.toString();
        return str;
    }

    public String getContentType(HttpRequest request) {
        String contentType = request.getRequestHeader("Content-Type");
        if (contentType == null) {
            contentType = request.getRequestHeader("Content-type");
        }
        return contentType;
    }

    public OgnlContext getOgnlContext() {
        return this.ognlContext;
    }

    public Map<String, Object> getAllParamMap(RequestMethodBean methodBean, HttpRequest request) {
        HashMap<String, Object> allParamsMap = new HashMap<String, Object>();
        if (methodBean != null) {
            allParamsMap.putAll(this.getPathParamsValue(methodBean.getUrl(), request.getPath()));
            if (methodBean.getRequestType().equals((Object)RequestType.JSON) && request.getMethod().equals("POST")) {
                JSONObject jsonObject = JSON.parseObject((String)new String(request.getPostData()));
                allParamsMap.putAll((Map<String, Object>)jsonObject);
            }
        }
        allParamsMap.putAll(request.getParameterMap());
        allParamsMap.putAll(this.getRefererHeardMap(request));
        if (allParamsMap.get("projectVersionName") == null || allParamsMap.get("projectVersionName").equals("")) {
            try {
                allParamsMap.put("projectVersionName", this.getProjectName(request));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return allParamsMap;
    }

    private Map<String, Object> getRefererHeardMap(HttpRequest request) {
        HashMap<String, Object> refererHeardMap = new HashMap<String, Object>();
        if (request.getHeaders().get("Referer") != null) {
            URL parenturl = null;
            try {
                parenturl = new URL(request.getHeaders().get("Referer").toString());
                refererHeardMap.putAll(this.createQueryMap(parenturl.getQuery()));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return refererHeardMap;
    }

    Object getRealService(Class clazz) throws OgnlException {
        Object service = null;
        service = clazz.getInterfaces().length > 0 ? EsbUtil.parExpression(clazz.getInterfaces()[0]) : EsbUtil.parExpression((Class)clazz);
        if (service == null) {
            if (clazz.isInterface()) {
                Aggregation aggregation = clazz.getAnnotation(Aggregation.class);
                if (aggregation != null && !aggregation.rootClass().equals(Void.class) && !aggregation.rootClass().equals(clazz)) {
                    clazz = aggregation.rootClass();
                    service = this.getRealService(clazz);
                }
            } else {
                service = OgnlRuntime.callConstructor((OgnlContext)this.getOgnlContext(), (String)clazz.getName(), (Object[])new Object[0]);
            }
        }
        return service;
    }

    public Object getService(RequestMethodBean methodBean, HttpRequest request) throws ClassNotFoundException, OgnlException {
        Map<String, Object> allParamsMap = this.getAllParamMap(methodBean, request);
        Class clazz = ClassUtility.loadClass((String)methodBean.getClassName());
        Object service = this.getRealService(clazz);
        for (Field field : clazz.getDeclaredFields()) {
            if (allParamsMap.get(field.getName()) == null) continue;
            try {
                OgnlRuntime.setProperty((OgnlContext)this.getOgnlContext(), (Object)service, (Object)field.getName(), (Object)TypeUtils.castToJavaBean((Object)allParamsMap.get(field.getName()), field.getType()));
            }
            catch (OgnlException ognlException) {
                // empty catch block
            }
        }
        return service;
    }

    protected boolean isRequestdForHandler(HttpRequest request) {
        return request.getUrl().startsWith(this.getUrlPrefix());
    }

    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        return false;
    }

    @Override
    public boolean shutdown(Server server) {
        return true;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Map getContextMap() {
        if (this.contextMap == null) {
            this.contextMap = new HashMap();
            for (Object obj : ActionContext.getContext().getValueStack().getRoot()) {
                if (!(obj instanceof Map)) continue;
                this.contextMap.putAll((Map)obj);
            }
        }
        return this.contextMap;
    }

    protected String getMimeType(String filename) {
        int index = filename.lastIndexOf(".");
        String mimeType = null;
        if (index > 0) {
            mimeType = this.server.getProperty("mime" + filename.substring(index).toLowerCase());
        }
        return mimeType;
    }

    public void copyStreamToFile(InputStream input, File file) throws IOException {
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists() && !file.canWrite()) {
            String message = "Unable to open file " + file + " for writing.";
            throw new IOException(message);
        }
        if (input != null) {
            FileOutputStream output = new FileOutputStream(file);
            IOUtility.copy((InputStream)input, (OutputStream)output);
            IOUtility.shutdownStream((InputStream)input);
            IOUtility.shutdownStream((OutputStream)output);
        }
    }

    public void copyStreamToFile(String url, File file) throws IOException {
        URL source = new URL(url);
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists() && !file.canWrite()) {
            String message = "Unable to open file " + file + " for writing.";
            throw new IOException(message);
        }
        InputStream input = source.openStream();
        FileOutputStream output = new FileOutputStream(file);
        IOUtility.copy((InputStream)input, (OutputStream)output);
        IOUtility.shutdownStream((InputStream)input);
        IOUtility.shutdownStream((OutputStream)output);
    }

    private RequestMethodBean findMethodBean(String path) {
        RequestMethodBean methodBean = APIConfigFactory.getInstance().getRequestMappingBean(path);
        if (methodBean == null) {
            methodBean = APIConfigFactory.getInstance().findMethodBean(path);
        }
        return methodBean;
    }

    public RequestMethodBean getRequestMethodBean(HttpRequest request) throws MalformedURLException {
        String url = request.getUrl();
        RequestMethodBean methodBean = this.findMethodBean(url);
        String projectName = this.getProjectName(request);
        String path = this.formatPath(url, projectName);
        if (methodBean == null) {
            for (String patt : pattArr) {
                if (!path.endsWith(patt)) continue;
                path = path.substring(0, path.length() - patt.length());
            }
            path = StringUtility.replace((String)path, (String)".", (String)"/");
            methodBean = this.findMethodBean(path);
        }
        if (methodBean == null && projectName != null) {
            if (projectName.indexOf("VVV") > -1) {
                projectName = projectName.split("VVV")[0];
            }
            methodBean = this.findMethodBean(projectName + "/" + path);
        }
        return methodBean;
    }

    public void setOgnlContext(OgnlContext ognlContext) {
        this.ognlContext = ognlContext;
    }
}

