/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server.httpproxy;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.StringUtility;
import com.ds.config.JDSUtil;
import com.ds.config.UserBean;
import com.ds.server.httpproxy.core.ChainableProperties;
import com.ds.server.httpproxy.core.ProxyHost;
import com.ds.server.httpproxy.core.Server;
import com.ds.server.httpproxy.nioproxy.ProxyServer;
import com.ds.web.APIConfigFactory;
import com.ds.web.RequestMethodBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.nio.reactor.IOReactorException;

public class ServerProxyFactory {
    public static ServerProxyFactory serverFactory;
    public static Map<String, ProxyHost> serverProxyMap;
    public static Map<String, Server> serverMap;
    public static final String THREAD_LOCK = "Thread Lock";
    public static final String AdmainHost = "itjds.net";
    public static final String protPropertes = "http.port";
    public static final String[] OtherUrlfilter;
    public static final String[] CDNUrlfilter;
    public static final String[] RADUrlfilter;
    public static final String[] localUrlfilte;
    public static final String[] CustomUrlfilte;
    public Server adminServer;
    public Server customServer;
    public Server webServer;
    public ProxyServer proxyServer;
    private static final Log logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerProxyFactory getInstance() {
        if (serverFactory != null) return serverFactory;
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            if (serverFactory != null) return serverFactory;
            serverFactory = new ServerProxyFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return serverFactory;
        }
    }

    void loadProject() {
    }

    public void clear() {
        serverProxyMap.clear();
        serverMap.clear();
    }

    ServerProxyFactory() {
        this.start();
    }

    public Server getWebServer() {
        return this.webServer;
    }

    public void setWebServer(Server webServer) {
        this.webServer = webServer;
    }

    void start() {
        this.startAdminServer();
        this.startProxyServer();
        this.startCustomServer();
        this.startWebServer();
        String defalutAppUrl = System.getProperty("appUrl");
        String proxyUrl = System.getProperty("proxyUrl");
        String indexPage = System.getProperty("indexPage");
        String proxyPort = System.getProperty("proxyPort");
        if (proxyPort == null || proxyPort.equals("")) {
            proxyPort = UserBean.getInstance().getEsdServerPort();
        }
        String defalutProjectName = System.getProperty("projectName");
        if (defalutAppUrl != null && defalutProjectName != null) {
            try {
                if (defalutAppUrl.indexOf("\"") > -1) {
                    defalutAppUrl = defalutAppUrl.substring(1, defalutAppUrl.length() - 1);
                }
                if (defalutAppUrl.indexOf("$") > -1) {
                    String[] defalutAppUrls;
                    for (String url : defalutAppUrls = StringUtility.split((String)defalutAppUrl, (String)"$")) {
                        if (!url.startsWith("http")) {
                            url = "http://" + url;
                        }
                        this.createProxy(new URL(url), defalutProjectName, indexPage, proxyUrl, null);
                    }
                } else if (defalutAppUrl.indexOf("|") > -1) {
                    String[] defalutAppUrls;
                    for (String url : defalutAppUrls = StringUtility.split((String)defalutAppUrl, (String)"|")) {
                        if (!url.startsWith("http")) {
                            url = "http://" + url;
                        }
                        this.createProxy(new URL(url), defalutProjectName, indexPage, proxyUrl, proxyPort);
                    }
                } else {
                    if (!defalutAppUrl.startsWith("http")) {
                        defalutAppUrl = "http://" + defalutAppUrl;
                    }
                    this.createProxy(new URL(defalutAppUrl), defalutProjectName, indexPage, proxyUrl, proxyPort);
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void startProxyServer() {
        try {
            Integer proxyPort = UserBean.getInstance().getProxyPort();
            this.proxyServer = new ProxyServer(proxyPort);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ServerProxyFactory.this.proxyServer.start();
                }
            }).start();
        }
        catch (IOReactorException e) {
            e.printStackTrace();
        }
    }

    public ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(ProxyServer proxyServer) {
        this.proxyServer = proxyServer;
    }

    public HttpHost getProxyHost(HttpRequest request) {
        HttpHost target;
        block8: {
            String urlStr = request.getRequestLine().getUri();
            if (urlStr.indexOf("google") > -1) {
                return new HttpHost(urlStr);
            }
            String protocol = request.getProtocolVersion().getProtocol().toLowerCase();
            String host = request.getFirstHeader("host").getValue();
            if (!urlStr.toLowerCase().startsWith(protocol)) {
                urlStr = urlStr.startsWith(host) ? protocol + "://" + urlStr : protocol + "://" + host + urlStr;
            }
            if (urlStr.endsWith(":443")) {
                urlStr = urlStr.substring(0, urlStr.length() - ":443".length());
            }
            target = null;
            try {
                try {
                    URL sourceUrl = new URL(urlStr);
                    String proxyUrl = this.getProxyUrl(sourceUrl);
                    URL url = new URL(proxyUrl);
                    if (sourceUrl != null && url == null) {
                        target = new HttpHost(sourceUrl.getHost(), sourceUrl.getPort(), sourceUrl.getProtocol());
                        break block8;
                    }
                    target = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
                    request.setHeader("Host", url.getHost());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return target;
    }

    String getProxyUrl(URL url) {
        Object pattern;
        boolean ruleMatches;
        Pattern rule;
        boolean ruleMatches2;
        Pattern rule2;
        String adminUrl = "http://" + this.getLocalIp() + ":" + this.adminServer.getProperty(protPropertes);
        String customUrl = "http://" + this.getLocalIp() + ":" + this.customServer.getProperty(protPropertes);
        for (String otherUrl : CustomUrlfilte) {
            rule2 = Pattern.compile(otherUrl);
            ruleMatches2 = rule2.matcher(url.getPath()).matches();
            if (!ruleMatches2) continue;
            return customUrl;
        }
        if (url.getHost().equals(AdmainHost)) {
            return adminUrl;
        }
        for (String otherUrl : OtherUrlfilter) {
            rule2 = Pattern.compile(otherUrl);
            ruleMatches2 = rule2.matcher(url.toString()).matches();
            if (!ruleMatches2) continue;
            return url.toString();
        }
        for (String otherUrl : CDNUrlfilter) {
            rule2 = Pattern.compile(otherUrl);
            ruleMatches2 = rule2.matcher(url.toString()).matches();
            if (!ruleMatches2) continue;
            return adminUrl;
        }
        ProxyHost proxy = this.getProxy(url);
        if (proxy == null) {
            try {
                proxy = this.createProxy(url, null, null, null, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String localProxy = url.getProtocol() + "://" + proxy.getLocalIp() + ":" + proxy.getPort();
        for (String otherUrl : localUrlfilte) {
            rule = Pattern.compile(otherUrl);
            ruleMatches = rule.matcher(url.getPath()).matches();
            if (!ruleMatches) continue;
            return localProxy;
        }
        if (proxy.getProjectName() != null && (pattern = Pattern.compile(".*/(" + proxy.getProjectName() + ")//?.*")) != null && ((Pattern)pattern).matcher(url.getPath()).matches()) {
            return localProxy;
        }
        for (String otherUrl : RADUrlfilter) {
            rule = Pattern.compile(otherUrl);
            ruleMatches = rule.matcher(url.getPath()).matches();
            if (!ruleMatches) continue;
            return localProxy;
        }
        RequestMethodBean methodBean = APIConfigFactory.getInstance().findMethodBean(url.getPath());
        if (methodBean != null) {
            return localProxy;
        }
        String proxyUrl = proxy.getProxyUrl();
        if (!proxyUrl.toLowerCase().startsWith("http")) {
            proxyUrl = "http://" + proxyUrl;
        }
        logger.info((Object)("\u6e90\u5730\u5740\uff1a" + url.getPath() + "\u8f6c\u5411\u5730\u5740\uff1a" + proxyUrl));
        return proxyUrl;
    }

    void startCustomServer() {
        if (this.customServer == null) {
            Properties props = new Properties();
            try {
                File engineConfigFile = new File(JDSUtil.getJdsRealPath(), "customserver.properties");
                props.load(new FileInputStream(engineConfigFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            props.setProperty(protPropertes, this.getLocalPort());
            ChainableProperties config = new ChainableProperties(props);
            this.customServer = new Server(config);
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ServerProxyFactory.this.customServer.start();
                        Server server = ServerProxyFactory.this.customServer;
                        synchronized (server) {
                            ServerProxyFactory.this.customServer.wait();
                        }
                    }
                    catch (Exception e) {
                        ServerProxyFactory.this.customServer.getConfig().setProperty(ServerProxyFactory.protPropertes, ServerProxyFactory.getLocalPort());
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    void startAdminServer() {
        if (this.adminServer == null) {
            Properties props = new Properties();
            try {
                File engineConfigFile = new File(JDSUtil.getJdsRealPath(), "consoleserver.properties");
                props.load(new FileInputStream(engineConfigFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            props.setProperty(protPropertes, ServerProxyFactory.getLocalPort());
            ChainableProperties config = new ChainableProperties(props);
            this.adminServer = new Server(config);
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ServerProxyFactory.this.adminServer.start();
                        Server server = ServerProxyFactory.this.adminServer;
                        synchronized (server) {
                            ServerProxyFactory.this.adminServer.wait();
                        }
                    }
                    catch (Exception e) {
                        ServerProxyFactory.this.adminServer.getConfig().setProperty(ServerProxyFactory.protPropertes, ServerProxyFactory.getLocalPort());
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    void startWebServer() {
        if (this.webServer == null) {
            Properties props = new Properties();
            try {
                File engineConfigFile = new File(JDSUtil.getJdsRealPath(), "server.properties");
                props.load(new FileInputStream(engineConfigFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String webServerPort = UserBean.getInstance().getWebServerPort();
            webServerPort = this.checkPort(webServerPort);
            props.setProperty(protPropertes, webServerPort);
            ChainableProperties config = new ChainableProperties(props);
            this.webServer = new Server(config);
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ServerProxyFactory.this.webServer.start();
                        Server server = ServerProxyFactory.this.webServer;
                        synchronized (server) {
                            ServerProxyFactory.this.webServer.wait();
                        }
                    }
                    catch (Exception e) {
                        ServerProxyFactory.this.webServer.getConfig().setProperty(ServerProxyFactory.protPropertes, ServerProxyFactory.getLocalPort());
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    void startDebugServer() {
        if (this.adminServer == null) {
            Properties props = new Properties();
            try {
                File engineConfigFile = new File(JDSUtil.getJdsRealPath(), "consoleserver.properties");
                props.load(new FileInputStream(engineConfigFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            props.setProperty(protPropertes, ServerProxyFactory.getLocalPort());
            ChainableProperties config = new ChainableProperties(props);
            this.adminServer = new Server(config);
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ServerProxyFactory.this.adminServer.start();
                        Server server = ServerProxyFactory.this.adminServer;
                        synchronized (server) {
                            ServerProxyFactory.this.adminServer.wait();
                        }
                    }
                    catch (Exception e) {
                        ServerProxyFactory.this.adminServer.getConfig().setProperty(ServerProxyFactory.protPropertes, ServerProxyFactory.getLocalPort());
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void shutdown() {
        this.customServer.shutdown();
        this.customServer = null;
        this.adminServer.shutdown();
        this.adminServer = null;
        this.webServer.shutdown();
        this.webServer = null;
        this.proxyServer.stop();
        this.proxyServer = null;
        this.clear();
        this.start();
    }

    public List<ProxyHost> getProxyList() {
        Set<String> keySet = serverProxyMap.keySet();
        ArrayList<ProxyHost> proxyHostLis = new ArrayList<ProxyHost>();
        for (String hostName : keySet) {
            ProxyHost proxyHost = serverProxyMap.get(hostName);
            if (proxyHost == null) continue;
            proxyHostLis.add(proxyHost);
        }
        return proxyHostLis;
    }

    public ProxyHost getProxy(URL url) {
        Server server;
        ProxyHost host = serverProxyMap.get(url.getHost());
        if (!(host == null || (server = serverMap.get(host.getHost())) != null && server.isStarted())) {
            host = this.createProxy(host);
            serverProxyMap.put(url.getHost(), host);
        }
        return host;
    }

    private String checkPort(String localPort) {
        if (localPort == null || localPort.equals("")) {
            localPort = ServerProxyFactory.getLocalPort();
        } else {
            ServerSocket s = null;
            try {
                s = new ServerSocket(Integer.valueOf(localPort));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (s == null) {
                localPort = ServerProxyFactory.getLocalPort();
            } else {
                try {
                    s.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return localPort;
    }

    public ProxyHost createProxy(ProxyHost hostProxy) {
        Server server = serverMap.get(hostProxy.getHost());
        ProxyHost proxyHost = null;
        if (server == null || !server.isStarted()) {
            try {
                String localPort = hostProxy.getPort();
                localPort = this.checkPort(localPort);
                hostProxy.setPort(localPort);
                hostProxy.setLocalIp(this.getLocalIp());
                File engineConfigFile = new File(JDSUtil.getJdsRealPath(), "server.properties");
                if (engineConfigFile.exists()) {
                    hostProxy.setPropertiesFile(engineConfigFile.getAbsolutePath());
                }
                final Server proxyServer = new Server(hostProxy);
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            proxyServer.start();
                            countDownLatch.countDown();
                            Server server = proxyServer;
                            synchronized (server) {
                                proxyServer.wait();
                            }
                        }
                        catch (Exception e) {
                            proxyServer.shutdown();
                            String port = ServerProxyFactory.getLocalPort();
                            proxyServer.getConfig().setProperty(ServerProxyFactory.protPropertes, port);
                            proxyServer.getProxyHost().setPort(port);
                            try {
                                proxyServer.start();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            countDownLatch.countDown();
                        }
                    }
                }).start();
                countDownLatch.await();
                serverMap.put(proxyServer.getProxyHost().getHost(), proxyServer);
                serverProxyMap.put(proxyServer.getProxyHost().getHost(), proxyServer.getProxyHost());
                server = proxyServer;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        proxyHost = server.getProxyHost();
        return proxyHost;
    }

    public ProxyHost createProxy(URL url, String projectName, String indexPage, String proxyHost, String localPort) throws IOException {
        ProxyHost host;
        if (projectName == null) {
            projectName = System.getProperty("projectName");
        }
        if (proxyHost == null) {
            proxyHost = System.getProperty("proxyUrl");
        }
        if (indexPage == null) {
            indexPage = System.getProperty("indexPage");
        }
        if ((host = this.getProxy(url)) == null) {
            localPort = this.getLocalPort();
            String localIP = this.getLocalIp();
            File engineConfigFile = new File(JDSUtil.getJdsRealPath(), "server.properties");
            logger.info((Object)("\u5f00\u59cb\u521b\u5efa\u65b0\u4ee3\u7406\u670d\u52a1\u5668 url \uff1a" + url.toString() + "projectName\uff1a" + projectName + "proxyHost:" + proxyHost + " indexPage:" + indexPage));
            host = new ProxyHost(url, projectName, engineConfigFile.getPath(), localIP, localPort, indexPage, proxyHost);
            host = this.createProxy(host);
        } else {
            localPort = this.checkPort(host.getPort());
            host.setLocalIp(this.getLocalIp());
            host.setPort(localPort);
            if (projectName != null) {
                host.setProjectName(projectName);
            }
            if (indexPage != null) {
                host.setIndexPage(indexPage);
            }
            logger.info((Object)("\u5f00\u59cb\u521b\u5efa\u65b0\u4ee3\u7406\u670d\u52a1\u5668 url \uff1a" + host.toString() + "projectName\uff1a" + projectName + "proxyHost:" + proxyHost + " indexPage:" + indexPage));
            host = this.createProxy(host);
        }
        return host;
    }

    private String getLocalIp() {
        String localIp = "127.0.0.1";
        try {
            localIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return localIp;
    }

    public static boolean isLocalPortUsing(int port) {
        boolean flag = true;
        try {
            flag = ServerProxyFactory.isPortUsing("127.0.0.1", port);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    public static boolean isPortUsing(String host, int port) throws UnknownHostException {
        boolean flag = false;
        InetAddress Address = InetAddress.getByName(host);
        try {
            Socket socket = new Socket(Address, port);
            flag = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return flag;
    }

    public static String getLocalPort() {
        ServerSocket s = null;
        String port = "8083";
        try {
            s = new ServerSocket(0);
            port = s.getLocalPort() + "";
            s.close();
        }
        catch (MalformedURLException e3) {
            e3.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        return port;
    }

    public Server getAdminServer() {
        return this.adminServer;
    }

    public void setAdminServer(Server adminServer) {
        this.adminServer = adminServer;
    }

    public Server getCustomServer() {
        return this.customServer;
    }

    public void setCustomServer(Server customServer) {
        this.customServer = customServer;
    }

    static {
        serverProxyMap = new HashMap<String, ProxyHost>();
        serverMap = new HashMap<String, Server>();
        OtherUrlfilter = new String[]{".*googleapis.com//?.*", ".*cloudflare.com//?.*", ".*beacons.*?.*\\.gvt.*?\\.com//.*", ".*click.com//?.*", ".*beacons.*?.*\\.gvt.?\\.com//.*", ".*gvt1.com//?.*"};
        CDNUrlfilter = new String[]{".*alicdn.com//?.*"};
        RADUrlfilter = new String[]{".*/(public|custom|RAD|plugins|xui|root|debug|jds|vfs)//?.*", ".*?/.*\\.(dyn|cls)$"};
        localUrlfilte = new String[]{".*/favicon.ico"};
        CustomUrlfilte = new String[]{"/(custom|thumbnail)//?.*", ".*?/.*\\.view$"};
        logger = LogFactory.getLog((String)"JDS", ServerProxyFactory.class);
    }
}

