/*
 * Decompiled with CFR 0.152.
 */
package com.ds.server;

import com.alibaba.fastjson.JSONObject;
import com.ds.cluster.udp.ClusterCommand;
import com.ds.cluster.udp.ClusterEvent;
import com.ds.cluster.udp.HeardInfo;
import com.ds.common.JDSException;
import com.ds.common.MsgStatus;
import com.ds.common.cache.CacheManagerFactory;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.JDSConfig;
import com.ds.server.udp.HeartCommand;
import com.ds.server.udp.RepeatCMDMsg;
import com.ds.server.udp.RepeatClientMsg;
import com.ds.server.udp.RepeatEventMsg;
import com.ds.server.udp.RepeatPersonClientMsg;
import com.ds.thread.JDSThreadFactory;
import com.ds.web.ConnectionLogFactory;
import com.ds.web.RemoteConnectionManager;
import com.ds.web.RuntimeLog;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public class JDSUDPServer {
    public static final String SPLITOR = "|";
    public static JDSUDPServer JDSUDPServer;
    private static JDSUDPServer instance;
    private DatagramSocket pushMsgSocket;
    public static final String THREAD_LOCK = "Thread Lock";
    private String code;
    private Integer port;
    private static final String DEFAULT_UDPCODE = "utf-8";
    private static final int DEFAULT_UDPPORT = 8087;
    public static boolean started;
    public static final String SUCCESS_KEY = "success";
    public static final String ERROR_KEY = "error";
    public static final String HIT_KEY = "0";
    public static final String START_KEY = "{";
    public static final String END_KEY = "}";
    public static final String STATUS_SPLIT_KEY = "&&";
    public static final String STATUS_START_KEY = "##||";
    public static final String STATUS_END_KEY = "||##";
    public static final String PERSON_SPLIT_KEY = "||||";
    public static final String PERSON_CLIENT_KEY = "||&&&&";
    public static final String LOGIN_KEY = "{\"event\":1001,\"msgStr\":\"session error\"}";
    public static final String SESSIONID = "sessionId";
    public static final String SYSTEMCODE = "systemCode";
    private static final Log logger;
    ExecutorService heartService = Executors.newFixedThreadPool(150, (ThreadFactory)new JDSThreadFactory("HeartService"));
    private Map<String, Set<String>> repeatEventKeyMap = CacheManagerFactory.createCache((String)"JDS", (String)"RepeatEventKeyMap");
    private Map<String, Set<String>> msg2personEventMap = CacheManagerFactory.createCache((String)"JDS", (String)"Msg2personEventMap");
    static Map<String, ScheduledExecutorService> heartServiceMap;
    private static JDSUDPServer udpServer;

    public Set<String> getRepeatEventKey(String systemId) {
        Set<String> eventKeys = this.repeatEventKeyMap.get(systemId);
        if (eventKeys == null) {
            eventKeys = new HashSet<String>();
            this.repeatEventKeyMap.put(systemId, eventKeys);
        }
        return eventKeys;
    }

    public Map<String, Set<String>> getAllRepeatEventKey() {
        HashMap<String, Set<String>> allRepeatEventKeyMap = new HashMap<String, Set<String>>();
        Set<String> keySet = this.repeatEventKeyMap.keySet();
        for (String key : keySet) {
            if (key == null) continue;
            allRepeatEventKeyMap.put(key, this.repeatEventKeyMap.get(key));
        }
        return allRepeatEventKeyMap;
    }

    public Map<String, Set<String>> getAllPersonRepeatEventKey() {
        HashMap<String, Set<String>> allRepeatEventKeyMap = new HashMap<String, Set<String>>();
        Set<String> keySet = this.msg2personEventMap.keySet();
        for (String key : keySet) {
            if (key == null) continue;
            allRepeatEventKeyMap.put(key, this.msg2personEventMap.get(key));
        }
        return allRepeatEventKeyMap;
    }

    public void removeRepeatEventKey(String systemId, String serviceKey, String personId) {
        Set<String> eventKeys = this.getRepeatEventKey(systemId);
        eventKeys.remove(serviceKey);
        this.repeatEventKeyMap.put(systemId, eventKeys);
        Set<String> devPersonEventKeys = this.getRepeatPersonEventKey(systemId, serviceKey);
        devPersonEventKeys.remove(personId);
        this.msg2personEventMap.put(systemId + SPLITOR + serviceKey, devPersonEventKeys);
    }

    public Set<String> getRepeatPersonEventKey(String systemId, String serviceKey) {
        String eventRepeartKey = systemId + SPLITOR + serviceKey;
        Set<String> personIds = this.msg2personEventMap.get(eventRepeartKey);
        if (personIds == null) {
            personIds = new LinkedHashSet<String>();
            this.msg2personEventMap.put(eventRepeartKey, personIds);
        }
        HashSet<String> personIdSet = new HashSet<String>();
        for (String personId : personIds) {
            if (personId == null || personId.equals("")) continue;
            personIdSet.add(personId);
        }
        return personIdSet;
    }

    public void clearEventKey(String systemId) {
        this.repeatEventKeyMap.put(systemId, new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepeatEventKey(String systemId, String serviceKey, String personId) {
        String string = systemId + serviceKey;
        synchronized (string) {
            logger.info((Object)("start addRepeatEventKey  personId +" + personId + " systemId=" + systemId + " serviceKey=" + serviceKey));
            Set<String> eventKeys = this.getRepeatEventKey(systemId);
            eventKeys.add(serviceKey);
            Set<String> personIds = this.getRepeatPersonEventKey(systemId, serviceKey);
            if (!personIds.contains(personId)) {
                personIds.add(personId);
                String eventRepeartKey = systemId + SPLITOR + serviceKey;
                this.msg2personEventMap.put(eventRepeartKey, personIds);
            }
            this.repeatEventKeyMap.put(systemId, eventKeys);
        }
    }

    private JDSUDPServer(Integer port, String code) {
        this.code = code;
        this.port = port;
        this.msg2personEventMap.clear();
        this.repeatEventKeyMap.clear();
    }

    public boolean started() {
        return started;
    }

    public static JDSUDPServer getInstance() throws JDSException {
        String code;
        String portStr = JDSConfig.getValue((String)"udpServer.port");
        int port = 8087;
        if (portStr != null) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException nfe) {
                port = 8087;
            }
        }
        if ((code = JDSConfig.getValue((String)"udpServer.code")) == null) {
            code = DEFAULT_UDPCODE;
        }
        try {
            udpServer = com.ds.server.JDSUDPServer.getInstance(port, code);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return udpServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static JDSUDPServer getInstance(Integer port, String code) throws JDSException {
        if (instance != null) return instance;
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            if (instance != null) return instance;
            instance = new JDSUDPServer(port, code);
            String enable = JDSConfig.getValue((String)"udpServer.enabled");
            logger.info((Object)"************************************************");
            logger.info((Object)(" udpServer enable:" + enable));
            if (enable == null || !Boolean.valueOf(enable).booleanValue()) return instance;
            Executors.newSingleThreadExecutor((ThreadFactory)new JDSThreadFactory("JDSServer.startUDPServer")).execute(new Runnable(){

                @Override
                public void run() {
                    logger.info((Object)"start clearCache ");
                    udpServer.start();
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    public void start() {
        try {
            this.pushMsgSocket = new DatagramSocket(this.port);
            this.startPushMsgSocket();
            started = true;
        }
        catch (SocketException e) {
            e.printStackTrace();
            try {
                Thread.sleep(5000L);
                this.start();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
    }

    public synchronized boolean sendHeart(String ip, Integer port) throws JDSException {
        DatagramSocket socket = com.ds.server.JDSUDPServer.getInstance().getPushMsgSocket();
        DatagramPacket dp = null;
        try {
            dp = new DatagramPacket("{}".getBytes(), "{}".getBytes().length, InetAddress.getByName(ip), port);
            socket.send(dp);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return socket.isClosed() || !socket.isConnected();
    }

    public synchronized boolean send(String msgString, String ip, Integer port) throws JDSException {
        JDSUDPServer udpServer = com.ds.server.JDSUDPServer.getInstance();
        DatagramSocket socket = com.ds.server.JDSUDPServer.getInstance().getPushMsgSocket();
        try {
            msgString = URLEncoder.encode(msgString, udpServer.getCode());
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        DatagramPacket dp = null;
        try {
            dp = new DatagramPacket(msgString.getBytes(), msgString.getBytes().length, InetAddress.getByName(ip), port);
            socket.send(dp);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return socket.isClosed() || !socket.isConnected();
    }

    String encode(String msgString) {
        try {
            msgString = URLEncoder.encode(msgString, this.getCode());
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        return msgString;
    }

    private void startPushMsgSocket() {
        JDSUDPServer udpServer = null;
        try {
            udpServer = com.ds.server.JDSUDPServer.getInstance();
        }
        catch (JDSException e1) {
            e1.printStackTrace();
        }
        byte[] buf = new byte[8192];
        DatagramPacket p = new DatagramPacket(buf, 8192);
        boolean isEnd = false;
        while (!isEnd) {
            try {
                Runnable command;
                this.pushMsgSocket.receive(p);
                String content = new String(p.getData(), 0, p.getLength());
                String address = p.getAddress().getHostAddress();
                Integer port = p.getPort();
                String key = address + ":" + port;
                DatagramPacket sendPacket = new DatagramPacket(SUCCESS_KEY.getBytes(), SUCCESS_KEY.getBytes().length, p.getAddress(), port);
                ExecutorService cmdService = RemoteConnectionManager.getConntctionService((String)key);
                ExecutorService eventService = RemoteConnectionManager.getConntctionService((String)(key + ":event"));
                if (content.startsWith(URLEncoder.encode(START_KEY, udpServer.getCode())) && content.endsWith(URLEncoder.encode(END_KEY, udpServer.getCode()))) {
                    content = URLDecoder.decode(content, udpServer.getCode());
                    logger.info((Object)("content==========" + content));
                    JSONObject jsonobj = JSONObject.parseObject((String)content);
                    String sessionId = null;
                    String systemCode = null;
                    sessionId = jsonobj.containsKey((Object)SESSIONID) ? jsonobj.getString(SESSIONID) : jsonobj.getJSONObject("userinfo").getString(SESSIONID);
                    if (jsonobj.containsKey((Object)SYSTEMCODE)) {
                        systemCode = jsonobj.getString(SYSTEMCODE);
                    } else if (jsonobj.getJSONObject("userinfo") != null) {
                        systemCode = jsonobj.getJSONObject("userinfo").getString(SYSTEMCODE);
                    } else {
                        throw new JDSException("systemCode not in udpcontent=" + content);
                    }
                    if (sessionId == null || systemCode == null) continue;
                    if (jsonobj.containsKey((Object)"commandJson")) {
                        logger.info((Object)("msg json =======key=" + key + "[" + URLDecoder.decode(content, udpServer.getCode()) + "]"));
                        ClusterCommand command2 = (ClusterCommand)JSONObject.parseObject((String)content, ClusterCommand.class);
                        cmdService.execute(new RepeatCMDMsg(command2, systemCode));
                        continue;
                    }
                    if (jsonobj.containsKey((Object)"sourceJson")) {
                        logger.info((Object)("msg json =======key=" + key + "[" + URLDecoder.decode(content, udpServer.getCode()) + "]"));
                        ClusterEvent event = (ClusterEvent)JSONObject.parseObject((String)content, ClusterEvent.class);
                        event.setSendTime(Long.valueOf(System.currentTimeMillis()));
                        RepeatEventMsg eventRepeat = new RepeatEventMsg(event, systemCode);
                        eventService.execute(eventRepeat);
                        continue;
                    }
                    HeardInfo heardInfo = (HeardInfo)JSONObject.parseObject((String)content, HeardInfo.class);
                    this.heartService.execute(new HeartCommand(heardInfo, p.getAddress(), port));
                    continue;
                }
                if (content.startsWith(URLEncoder.encode(STATUS_START_KEY, udpServer.getCode())) && content.endsWith(URLEncoder.encode(STATUS_END_KEY, udpServer.getCode()))) {
                    String contentStr = URLDecoder.decode(content, udpServer.getCode());
                    String body = contentStr.substring(STATUS_START_KEY.length(), contentStr.length() - STATUS_END_KEY.length());
                    MsgStatus msgStatus = MsgStatus.READED;
                    String msgId = body;
                    if (body.indexOf(STATUS_SPLIT_KEY) <= -1) continue;
                    String[] strIdArr = body.split(STATUS_SPLIT_KEY);
                    msgId = strIdArr[0];
                    msgStatus = MsgStatus.fromType((String)strIdArr[1]);
                    RuntimeLog log = ConnectionLogFactory.getInstance().getLog(msgId);
                    if (log == null) continue;
                    if (msgStatus.equals((Object)MsgStatus.READED)) {
                        log.setArrivedTime(System.currentTimeMillis());
                        log.setTime(log.getArrivedTime() - log.getStartTime());
                    } else {
                        log.setEndTime(System.currentTimeMillis());
                        if (log.getArrivedTime() > 0L) {
                            log.setExetime(log.getEndTime() - log.getArrivedTime());
                        } else {
                            log.setExetime(log.getEndTime() - log.getStartTime());
                        }
                    }
                    log.setStatus(msgStatus);
                    continue;
                }
                if (content.indexOf(URLEncoder.encode(PERSON_CLIENT_KEY, udpServer.getCode())) > -1) {
                    command = new RepeatPersonClientMsg(URLDecoder.decode(content, udpServer.getCode()), SYSTEMCODE);
                    cmdService.execute(command);
                    continue;
                }
                if (content.indexOf(URLEncoder.encode(PERSON_CLIENT_KEY, udpServer.getCode())) > -1) {
                    command = new RepeatClientMsg(URLDecoder.decode(content, udpServer.getCode()));
                    cmdService.execute(command);
                    continue;
                }
                logger.error((Object)content);
                sendPacket = new DatagramPacket(ERROR_KEY.getBytes(), ERROR_KEY.getBytes().length, p.getAddress(), port);
                this.pushMsgSocket.send(sendPacket);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.pushMsgSocket.close();
    }

    public DatagramSocket getPushMsgSocket() {
        return this.pushMsgSocket;
    }

    public void setPushMsgSocket(DatagramSocket pushMsgSocket) {
        this.pushMsgSocket = pushMsgSocket;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getServerIP() {
        String serverIP = JDSConfig.getValue((String)"udpServer.serverIP");
        return serverIP;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    static {
        started = false;
        logger = LogFactory.getLog((String)"JDS", JDSUDPServer.class);
        heartServiceMap = new HashMap<String, ScheduledExecutorService>();
    }
}

