/*
 * Decompiled with CFR 0.152.
 */
package com.ds.bpm.plugins.listener;

import com.ds.bpm.plugins.listener.ListenerFormView;
import com.ds.bpm.plugins.listener.ListenerGridView;
import com.ds.common.JDSException;
import com.ds.common.util.StringUtility;
import com.ds.config.BPDProjectConfig;
import com.ds.config.CListener;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ListenerType;
import com.ds.config.ResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.bpm.BPMFactory;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.custom.annotation.CustomAnnotation;
import com.ds.esd.custom.annotation.DialogAnnotation;
import com.ds.esd.custom.annotation.FormViewAnnotation;
import com.ds.esd.custom.annotation.GridViewAnnotation;
import com.ds.esd.custom.api.annotation.APIEventAnnotation;
import com.ds.esd.custom.api.enums.CustomCallBack;
import com.ds.esd.custom.enums.CustomMenuItem;
import com.ds.esd.custom.module.annotation.ModuleAnnotation;
import com.ds.web.util.PageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/admin/bpd/listener/"})
@Controller
@MethodChinaName(cname="\u76d1\u542c\u5668", imageClass="bpmfont bpm-gongzuoliu-moxing")
public class ListenerManager {
    @CustomAnnotation(pid=true, hidden=true)
    private String projectId;

    @RequestMapping(value={"Listeners"})
    @GridViewAnnotation
    @ModuleAnnotation(imageClass="bpmfont bpm-gongzuoliu-moxing", caption="\u76d1\u542c\u5668")
    @ResponseBody
    @APIEventAnnotation(autoRun=true, bindMenu={CustomMenuItem.treeNodeEditor})
    public ListResultModel<List<ListenerGridView>> getListeners(String projectName, String listenerType) {
        ListResultModel result = new ListResultModel();
        ListenerType type = ListenerType.EXPRESSION;
        if (listenerType != null) {
            type = ListenerType.fromType((String)listenerType);
        }
        BPDProjectConfig config = null;
        try {
            ProjectVersion version = ESDFacrory.getESDClient().getProjectVersionByName(projectName);
            config = this.getConfig(version.getProject().getId());
            if (config != null) {
                switch (type) {
                    case RIGHT: {
                        result = PageUtil.getDefaultPageList((List)config.getRightListeners(), ListenerGridView.class);
                        break;
                    }
                    case ACTIVITY: {
                        result = PageUtil.getDefaultPageList((List)config.getActivityListeners(), ListenerGridView.class);
                        break;
                    }
                    case PROCESS: {
                        result = PageUtil.getDefaultPageList((List)config.getProcessListeners(), ListenerGridView.class);
                        break;
                    }
                    case EXPRESSION: {
                        result = PageUtil.getDefaultPageList((List)config.getBpdListeners(), ListenerGridView.class);
                    }
                }
            }
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u6dfb\u52a0\u76d1\u542c\u5668")
    @RequestMapping(method={RequestMethod.POST}, value={"saveListener"})
    @APIEventAnnotation(callback={CustomCallBack.ReloadParent, CustomCallBack.Close}, bindMenu={CustomMenuItem.save})
    @ResponseBody
    public ResultModel<Boolean> saveListener(@RequestBody ListenerFormView listenerView) {
        ResultModel result = new ResultModel();
        String projectId = listenerView.getProjectId();
        try {
            BPDProjectConfig config = BPMFactory.getInstance().getProjectConfig(projectId);
            CListener listener = new CListener();
            String listenerId = listenerView.getListenerId();
            if (listenerId == null || listenerId.equals("")) {
                listenerId = UUID.randomUUID().toString();
            }
            listener.setImplementation(listenerView.getImplementation());
            listener.setListenerId(listenerId);
            listener.setListenerType(listenerView.getListenerType());
            listener.setName(listenerView.getName());
            listener.setProjectId(listenerView.getProjectId());
            List<CListener> listeners = new ArrayList();
            switch (listenerView.getListenerType()) {
                case RIGHT: {
                    listeners = config.getRightListeners();
                    break;
                }
                case ACTIVITY: {
                    listeners = config.getActivityListeners();
                    break;
                }
                case PROCESS: {
                    listeners = config.getProcessListeners();
                    break;
                }
                case EXPRESSION: {
                    listeners = config.getBpdListeners();
                }
            }
            CListener oldListener = null;
            for (CListener cListener : listeners) {
                if (!cListener.getListenerId().equals(listener)) continue;
                oldListener = cListener;
            }
            if (oldListener != null) {
                listeners.remove(oldListener);
            }
            listeners.add(listener);
            BPMFactory.getInstance().updateProjectConfig(config);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"AddListener"})
    @APIEventAnnotation(bindMenu={CustomMenuItem.add, CustomMenuItem.editor})
    @FormViewAnnotation
    @DialogAnnotation(height="260", width="350")
    @ModuleAnnotation(caption="\u6dfb\u52a0\u76d1\u542c\u5668")
    @ResponseBody
    public ResultModel<ListenerFormView> addListener(String projectId, String pluginId, String listenerType) {
        ResultModel result = new ResultModel();
        try {
            BPDProjectConfig config = BPMFactory.getInstance().getProjectConfig(projectId);
            CListener listener = new CListener();
            String listenerId = UUID.randomUUID().toString();
            listener.setListenerId(listenerId);
            ListenerType type = ListenerType.EXPRESSION;
            if (listenerType != null) {
                type = ListenerType.fromType((String)listenerType);
                listener.setListenerType(type);
            }
            result.setData((Object)new ListenerFormView(listener));
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @MethodChinaName(cname="delListener")
    @RequestMapping(method={RequestMethod.POST}, value={"delListener"})
    @ResponseBody
    @APIEventAnnotation(callback={CustomCallBack.Reload})
    public ResultModel<Boolean> delListener(String listenerId, String projectId) {
        ResultModel result = new ResultModel();
        List<String> idarr = Arrays.asList(StringUtility.split((String)listenerId, (String)";"));
        try {
            BPDProjectConfig bpdProjectConfig = BPMFactory.getInstance().getProjectConfig(projectId);
            ArrayList<CListener> aListeners = new ArrayList<CListener>();
            for (Object listener : bpdProjectConfig.getActivityListeners()) {
                if (idarr.contains(listener.getListenerId())) continue;
                aListeners.add((CListener)listener);
            }
            bpdProjectConfig.setActivityListeners(aListeners);
            ArrayList pListeners = new ArrayList();
            for (Object listener : bpdProjectConfig.getProcessListeners()) {
                if (idarr.contains(listener.getListenerId())) continue;
                aListeners.add((CListener)listener);
            }
            bpdProjectConfig.setProcessListeners(pListeners);
            ArrayList rListeners = new ArrayList();
            for (CListener listener : bpdProjectConfig.getRightListeners()) {
                if (idarr.contains(listener.getListenerId())) continue;
                aListeners.add(listener);
            }
            bpdProjectConfig.setRightListeners(rListeners);
            ArrayList eListeners = new ArrayList();
            for (CListener elistener : bpdProjectConfig.getBpdListeners()) {
                if (idarr.contains(elistener.getListenerId())) continue;
                aListeners.add(elistener);
            }
            bpdProjectConfig.setBpdListeners(rListeners);
            BPMFactory.getInstance().updateProjectConfig(bpdProjectConfig);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(e.getErrorCode());
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    BPDProjectConfig getConfig(String projectId) throws JDSException {
        BPDProjectConfig config = BPMFactory.getInstance().getProjectConfig(projectId);
        return config;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
}

