/*
 * Decompiled with CFR 0.152.
 */
package com.ds.bpm.plugins.extendatt;

import com.ds.bpm.plugins.extendatt.ExtendAttributeFormView;
import com.ds.common.JDSException;
import com.ds.common.util.StringUtility;
import com.ds.config.BPDPlugin;
import com.ds.config.BPDProjectConfig;
import com.ds.config.CExtendedAttribute;
import com.ds.config.ErrorResultModel;
import com.ds.config.ResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.bpm.BPMFactory;
import com.ds.esd.custom.annotation.DialogAnnotation;
import com.ds.esd.custom.annotation.FormViewAnnotation;
import com.ds.esd.custom.api.annotation.APIEventAnnotation;
import com.ds.esd.custom.api.enums.CustomCallBack;
import com.ds.esd.custom.enums.CustomMenuItem;
import com.ds.esd.custom.module.annotation.ModuleAnnotation;
import java.util.UUID;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(path={"/admin/bpd/attribute/"})
@MethodChinaName(cname="\u6269\u5c55\u5c5e\u6027", imageClass="spafont spa-icon-tools")
public class ExtendAttributeManager {
    @RequestMapping(method={RequestMethod.POST}, value={"AddExtendAttributes"})
    @APIEventAnnotation(bindMenu={CustomMenuItem.add})
    @FormViewAnnotation
    @DialogAnnotation(height="260", width="350")
    @ModuleAnnotation(caption="\u6dfb\u52a0\u6269\u5c55\u5c5e\u6027")
    @ResponseBody
    public ResultModel<ExtendAttributeFormView> addAttribute(String projectId, String pluginId) {
        ResultModel result = new ResultModel();
        CExtendedAttribute cExtendedAttribute = new CExtendedAttribute();
        cExtendedAttribute.setPluginId(pluginId);
        cExtendedAttribute.setProjectId(projectId);
        cExtendedAttribute.setAttributeId(UUID.randomUUID().toString());
        result.setData((Object)new ExtendAttributeFormView(cExtendedAttribute));
        return result;
    }

    @MethodChinaName(cname="\u4fdd\u5b58\u6269\u5c55\u5c5e\u6027")
    @RequestMapping(method={RequestMethod.POST}, value={"saveAttribute"})
    @APIEventAnnotation(callback={CustomCallBack.ReloadParent, CustomCallBack.Close}, bindMenu={CustomMenuItem.save})
    @ResponseBody
    public ResultModel<Boolean> saveAttribute(@RequestBody ExtendAttributeFormView attribute) {
        ResultModel result = new ResultModel();
        String pluginId = attribute.getPluginId();
        String cExtendedAttributeId = attribute.getAttributeId();
        BPDPlugin plugin = null;
        try {
            plugin = this.getPluginById(attribute.getProjectId(), attribute.getPluginId());
            CExtendedAttribute cExtendedAttribute = new CExtendedAttribute();
            cExtendedAttribute.setPluginId(attribute.getPluginId());
            cExtendedAttribute.setProjectId(attribute.getProjectId());
            if (cExtendedAttributeId == null || cExtendedAttributeId.equals("")) {
                cExtendedAttribute.setAttributeId(UUID.randomUUID().toString());
            } else {
                cExtendedAttribute.setAttributeId(cExtendedAttributeId);
            }
            cExtendedAttribute.setType(attribute.getAttType());
            cExtendedAttribute.setName(attribute.getName());
            cExtendedAttribute.setValue(attribute.getAttValue());
            plugin.getExtendedAttributes().put(cExtendedAttribute.getAttributeId(), cExtendedAttribute);
            BPDProjectConfig bpdProjectConfig = BPMFactory.getInstance().getProjectConfig(plugin.getProjectId());
            BPMFactory.getInstance().updateProjectConfig(bpdProjectConfig);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(e.getErrorCode());
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"ExtendAttributeInfo"})
    @APIEventAnnotation(bindMenu={CustomMenuItem.editor})
    @FormViewAnnotation
    @DialogAnnotation(height="260", width="350")
    @ModuleAnnotation(caption="\u7f16\u8f91\u6269\u5c55\u5c5e\u6027")
    @ResponseBody
    public ResultModel<ExtendAttributeFormView> getAttributeInfo() {
        ResultModel result = new ResultModel();
        return result;
    }

    @MethodChinaName(cname="delExtendAttributes")
    @RequestMapping(method={RequestMethod.POST}, value={"delExtendAttributes"})
    @APIEventAnnotation(callback={CustomCallBack.Reload}, bindMenu={CustomMenuItem.delete})
    @ResponseBody
    public ResultModel<Boolean> delExtendAttributes(String attributeId, String projectId, String pluginId) {
        ResultModel result = new ResultModel();
        String[] idarr = StringUtility.split((String)attributeId, (String)";");
        BPDPlugin plugin = null;
        try {
            plugin = this.getPluginById(projectId, pluginId);
            for (String id : idarr) {
                plugin.getExtendedAttributes().remove(id);
            }
            BPDProjectConfig bpdProjectConfig = BPMFactory.getInstance().getProjectConfig(plugin.getProjectId());
            BPMFactory.getInstance().updateProjectConfig(bpdProjectConfig);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(e.getErrorCode());
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    BPDPlugin getPluginById(String projectId, String pluginId) throws JDSException {
        BPDProjectConfig config = BPMFactory.getInstance().getProjectConfig(projectId);
        BPDPlugin plugin = config.getPluginById(pluginId);
        return plugin;
    }
}

