/*
 * Decompiled with CFR 0.152.
 */
package com.ds.bpm.plugins.bpd;

import com.ds.bpm.plugins.bpd.PluginInfoFormView;
import com.ds.bpm.plugins.bpd.PluginMetaView;
import com.ds.common.JDSException;
import com.ds.config.BPDPlugin;
import com.ds.config.BPDProjectConfig;
import com.ds.config.ErrorResultModel;
import com.ds.config.ResultModel;
import com.ds.esd.bpm.BPMFactory;
import com.ds.esd.custom.annotation.CustomAnnotation;
import com.ds.esd.custom.annotation.FormViewAnnotation;
import com.ds.esd.custom.annotation.UIAnnotation;
import com.ds.esd.custom.annotation.nav.NavGroupAnnotation;
import com.ds.esd.custom.annotation.nav.NavTabsViewAnnotation;
import com.ds.esd.custom.annotation.toolbar.BottomBarMenu;
import com.ds.esd.custom.api.annotation.APIEventAnnotation;
import com.ds.esd.custom.form.enums.CustomFormMenu;
import com.ds.esd.custom.module.annotation.DynLoadAnnotation;
import com.ds.esd.custom.module.annotation.ModuleAnnotation;
import com.ds.esd.tool.ui.enums.Dock;
import java.util.UUID;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/admin/bpd/"})
@Controller
@BottomBarMenu
@NavGroupAnnotation(bottombarMenu={CustomFormMenu.Save, CustomFormMenu.Close})
public class PluginNav {
    @CustomAnnotation(uid=true, hidden=true)
    private String pluginId;
    @CustomAnnotation(pid=true, hidden=true)
    private String projectId;

    @RequestMapping(method={RequestMethod.POST}, value={"PluginInfo"})
    @FormViewAnnotation(saveUrl="updatePlugsInfo")
    @ModuleAnnotation(caption="\u57fa\u672c\u4fe1\u606f", dock=Dock.top)
    @UIAnnotation(height="160")
    @ResponseBody
    @APIEventAnnotation(autoRun=true)
    public ResultModel<PluginInfoFormView> getPluginInfo(String projectId, String name) {
        ResultModel result = new ResultModel();
        try {
            BPDProjectConfig config = this.getConfig(projectId);
            BPDPlugin element = null;
            if (name != null && !name.equals("")) {
                element = config.getElementByName(name);
            } else {
                element = new BPDPlugin();
                element.setPluginId(UUID.randomUUID().toString());
            }
            PluginInfoFormView info = new PluginInfoFormView(element);
            result.setData((Object)info);
        }
        catch (JDSException e) {
            e.printStackTrace();
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(e.getErrorCode());
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"PluginMetaInfo"})
    @DynLoadAnnotation
    @NavTabsViewAnnotation
    @ModuleAnnotation(caption="\u8be6\u7ec6\u4fe1\u606f", dock=Dock.fill)
    @ResponseBody
    public ResultModel<PluginMetaView> getPluginMetaInfo(String projectId, String pluginId) {
        ResultModel result = new ResultModel();
        return result;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    BPDProjectConfig getConfig(String projectId) throws JDSException {
        BPDProjectConfig config = BPMFactory.getInstance().getProjectConfig(projectId);
        return config;
    }
}

