/*
 * Decompiled with CFR 0.152.
 */
package com.ds.bpm.plugins.bpd;

import com.ds.bpm.plugins.extendatt.ExtendAttributeGridView;
import com.ds.bpm.plugins.formula.BPDFormulaView;
import com.ds.bpm.plugins.parameter.PluginParameterGridView;
import com.ds.common.JDSException;
import com.ds.config.BPDPlugin;
import com.ds.config.BPDProjectConfig;
import com.ds.config.CExtendedAttribute;
import com.ds.config.CFormula;
import com.ds.config.CParameter;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ListResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.bpm.BPMFactory;
import com.ds.esd.custom.annotation.CustomAnnotation;
import com.ds.esd.custom.annotation.GridViewAnnotation;
import com.ds.esd.custom.api.annotation.APIEventAnnotation;
import com.ds.esd.custom.buttonviews.annotation.ButtonViewsAnnotation;
import com.ds.esd.custom.module.annotation.ModuleAnnotation;
import com.ds.web.util.PageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/admin/bpd/"})
@Controller
@ButtonViewsAnnotation
public class PluginMetaView {
    @CustomAnnotation(uid=true, hidden=true)
    private String pluginId;
    @CustomAnnotation(pid=true, hidden=true)
    private String projectId;

    @MethodChinaName(cname="\u516c\u5f0f\u9762\u677f")
    @RequestMapping(value={"PluginFormulas"})
    @GridViewAnnotation
    @ModuleAnnotation(imageClass="spafont spa-icon-function", caption="\u516c\u5f0f\u9762\u677f")
    @CustomAnnotation(index=0)
    @APIEventAnnotation(autoRun=true)
    @ResponseBody
    public ListResultModel<List<BPDFormulaView>> getPluginFormulas(String projectId, String pluginId) {
        ListResultModel result = new ListResultModel();
        ArrayList<CFormula> bpdElements = new ArrayList<CFormula>();
        try {
            BPDPlugin plugin = this.getPluginById(projectId, pluginId);
            if (plugin != null) {
                Map cbpdElementMap = plugin.getFormulaTypeMap();
                Set keySet = cbpdElementMap.keySet();
                for (String key : keySet) {
                    CFormula element = (CFormula)cbpdElementMap.get(key);
                    bpdElements.add(element);
                }
                result = PageUtil.getDefaultPageList(bpdElements, BPDFormulaView.class);
            }
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u6269\u5c55\u5c5e\u6027")
    @RequestMapping(value={"ExtendAttributes"})
    @GridViewAnnotation
    @ModuleAnnotation(imageClass="spafont spa-icon-app", caption="\u6269\u5c55\u5c5e\u6027")
    @CustomAnnotation(index=1)
    @APIEventAnnotation(autoRun=true)
    @ResponseBody
    public ListResultModel<List<ExtendAttributeGridView>> getExtendAttributes(String projectId, String pluginId) {
        ListResultModel result = new ListResultModel();
        ArrayList<CExtendedAttribute> bpdElements = new ArrayList<CExtendedAttribute>();
        try {
            BPDPlugin plugin = this.getPluginById(projectId, pluginId);
            if (plugin != null) {
                Map cbpdElementMap = plugin.getExtendedAttributes();
                Set keySet = cbpdElementMap.keySet();
                for (String key : keySet) {
                    CExtendedAttribute element = (CExtendedAttribute)cbpdElementMap.get(key);
                    bpdElements.add(element);
                }
                result = PageUtil.getDefaultPageList(bpdElements, ExtendAttributeGridView.class);
            }
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u53c2\u6570")
    @RequestMapping(value={"Parameters"})
    @GridViewAnnotation
    @ModuleAnnotation(imageClass="spafont spa-icon-com3", caption="\u53c2\u6570")
    @CustomAnnotation(index=2)
    @APIEventAnnotation(autoRun=true)
    @ResponseBody
    public ListResultModel<List<PluginParameterGridView>> getParameters(String projectId, String pluginId) {
        ListResultModel result = new ListResultModel();
        ArrayList<CParameter> bpdElements = new ArrayList<CParameter>();
        try {
            BPDPlugin plugin = this.getPluginById(projectId, pluginId);
            if (plugin != null) {
                Map cbpdElementMap = plugin.getParameters();
                Set keySet = cbpdElementMap.keySet();
                for (String key : keySet) {
                    CParameter element = (CParameter)cbpdElementMap.get(key);
                    bpdElements.add(element);
                }
                result = PageUtil.getDefaultPageList(bpdElements, PluginParameterGridView.class);
            }
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    BPDPlugin getPluginById(String projectId, String pluginId) throws JDSException {
        BPDProjectConfig config = BPMFactory.getInstance().getProjectConfig(projectId);
        BPDPlugin plugin = config.getPluginById(pluginId);
        return plugin;
    }
}

