/*
 * Decompiled with CFR 0.152.
 */
package com.ds.bpm.plugins.bpd;

import com.ds.bpm.plugins.bpd.PluginInfoFormView;
import com.ds.bpm.plugins.bpd.PluginInfoGridView;
import com.ds.bpm.plugins.bpd.PluginNav;
import com.ds.bpm.plugins.view.ProjectListView;
import com.ds.common.JDSException;
import com.ds.common.util.StringUtility;
import com.ds.config.BPDPlugin;
import com.ds.config.BPDProjectConfig;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.PluginType;
import com.ds.config.ResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.bpm.BPMFactory;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.custom.annotation.DialogAnnotation;
import com.ds.esd.custom.annotation.GridViewAnnotation;
import com.ds.esd.custom.annotation.nav.NavGroupViewAnnotation;
import com.ds.esd.custom.api.annotation.APIEventAnnotation;
import com.ds.esd.custom.api.enums.CustomCallBack;
import com.ds.esd.custom.enums.CustomMenuItem;
import com.ds.esd.custom.module.annotation.ModuleAnnotation;
import com.ds.esd.project.enums.ProjectDefAccess;
import com.ds.web.util.PageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(path={"/admin/bpm/bpd/"})
@MethodChinaName(cname="\u5de5\u4f5c\u6d41\u914d\u7f6e", imageClass="bpmfont bpm-gongzuoliu-moxing")
public class BPDPluginService {
    @MethodChinaName(cname="\u5de5\u4f5c\u6d41\u63d2\u4ef6")
    @RequestMapping(value={"Plugins"})
    @GridViewAnnotation
    @ModuleAnnotation(imageClass="bpmfont bpm-gongzuoliu-moxing", caption="\u5de5\u4f5c\u6d41\u63d2\u4ef6")
    @APIEventAnnotation(autoRun=true, bindMenu={CustomMenuItem.treeNodeEditor})
    @ResponseBody
    public ListResultModel<List<PluginInfoGridView>> getProcessPlugins(String projectName, PluginType pluginType) {
        BPDProjectConfig config = null;
        ListResultModel result = new ListResultModel();
        ArrayList<BPDPlugin> bpdElements = new ArrayList<BPDPlugin>();
        try {
            ProjectVersion version = ESDFacrory.getESDClient().getProjectVersionByName(projectName);
            config = this.getConfig(version.getProject().getId());
            if (config != null) {
                List cbpdElements = config.getBpdElementsList();
                for (BPDPlugin plugin : cbpdElements) {
                    if (plugin.getPluginType() == null || !plugin.getPluginType().equals((Object)pluginType)) continue;
                    plugin.setProjectId(version.getProject().getId());
                    bpdElements.add(plugin);
                }
                result = PageUtil.getDefaultPageList(bpdElements, PluginInfoGridView.class);
            }
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    BPDProjectConfig getConfig(String projectId) throws JDSException {
        BPDProjectConfig config = BPMFactory.getInstance().getProjectConfig(projectId);
        return config;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"index"})
    @GridViewAnnotation
    @ModuleAnnotation(caption="\u5bfc\u822a\u9875")
    @ResponseBody
    @APIEventAnnotation(autoRun=true, bindMenu={CustomMenuItem.index})
    public ListResultModel<List<ProjectListView>> projectList(String projectName) {
        ListResultModel result = new ListResultModel();
        ArrayList views = new ArrayList();
        try {
            try {
                BPMFactory.getInstance().initFactory();
            }
            catch (JDSException e) {
                e.printStackTrace();
            }
            List projects = ESDFacrory.getESDClient().getAllProject(ProjectDefAccess.Public);
            result = PageUtil.getDefaultPageList((List)projects, ProjectListView.class);
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(e.getErrorCode());
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u63d2\u4ef6\u4fe1\u606f")
    @RequestMapping(method={RequestMethod.POST}, value={"PluginNav"})
    @NavGroupViewAnnotation
    @ModuleAnnotation(caption="\u63d2\u4ef6\u4fe1\u606f")
    @DialogAnnotation
    @APIEventAnnotation(bindMenu={CustomMenuItem.editor})
    @ResponseBody
    public ResultModel<PluginNav> pluginInfo(String projectId, String pluginId) {
        ResultModel result = new ResultModel();
        return result;
    }

    @MethodChinaName(cname="\u66f4\u65b0\u63d2\u4ef6\u4fe1\u606f")
    @RequestMapping(method={RequestMethod.POST}, value={"updatePlugsInfo"})
    @APIEventAnnotation(callback={CustomCallBack.ReloadParent, CustomCallBack.Close}, bindMenu={CustomMenuItem.save})
    @ResponseBody
    public ResultModel<PluginInfoFormView> updatePlugsInfo(@RequestBody PluginInfoFormView pluginView) {
        String pluginId = pluginView.getPluginId();
        ResultModel result = new ResultModel();
        String projectId = pluginView.getProjectId();
        try {
            BPDProjectConfig bpdProjectConfig = BPMFactory.getInstance().getProjectConfig(projectId);
            BPDPlugin plugin = null;
            if (pluginId == null || pluginId.equals("")) {
                plugin = new BPDPlugin();
                plugin.setPluginId(UUID.randomUUID().toString());
                bpdProjectConfig.getBpdElementsList().add(plugin);
            } else {
                plugin = bpdProjectConfig.getPluginById(pluginId);
                if (plugin == null) {
                    plugin = new BPDPlugin();
                    plugin.setPluginId(pluginId);
                    bpdProjectConfig.getBpdElementsList().add(plugin);
                }
            }
            plugin.setName(pluginView.getName());
            plugin.setDisplayname(pluginView.getDisplayname());
            plugin.setHeight(pluginView.getPanelHeight());
            plugin.setWidth(pluginView.getWidth());
            plugin.setImplementation(pluginView.getImplementation());
            plugin.setPluginType(pluginView.getPluginType());
            plugin.setActivityType(pluginView.getActivityType());
            plugin.setStatus(pluginView.getStatus());
            plugin.setProjectId(pluginView.getProjectId());
            BPMFactory.getInstance().updateProjectConfig(bpdProjectConfig);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(e.getErrorCode());
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="deletePlugins")
    @APIEventAnnotation(callback={CustomCallBack.Reload}, bindMenu={CustomMenuItem.delete})
    @RequestMapping(method={RequestMethod.POST}, value={"deletePlugins"})
    @ResponseBody
    public ResultModel<Boolean> deletePlugins(String projectId, String pluginId) {
        ResultModel result = new ResultModel();
        try {
            BPDProjectConfig bpdProjectConfig = BPMFactory.getInstance().getProjectConfig(projectId);
            List<String> idarr = Arrays.asList(StringUtility.split((String)pluginId, (String)";"));
            ArrayList<BPDPlugin> plugins = new ArrayList<BPDPlugin>();
            for (BPDPlugin plugin : bpdProjectConfig.getBpdElementsList()) {
                if (idarr.contains(plugin.getPluginId())) continue;
                plugins.add(plugin);
            }
            bpdProjectConfig.setBpdElementsList(plugins);
            BPMFactory.getInstance().updateProjectConfig(bpdProjectConfig);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(e.getErrorCode());
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    BPDPlugin getPluginById(String projectId, String pluginId) throws JDSException {
        BPDProjectConfig config = BPMFactory.getInstance().getProjectConfig(projectId);
        BPDPlugin plugin = config.getPluginById(pluginId);
        return plugin;
    }
}

