package com.ds.bpm.plugins.nav;

import com.ds.config.ListenerType;
import com.ds.esd.custom.annotation.TreeAnnotation;
import com.ds.esd.custom.annotation.nav.NavFoldingTreeAnnotation;
import com.ds.esd.custom.annotation.nav.TabsAnnotation;
import com.ds.esd.tool.ui.component.list.TreeListItem;

import java.util.HashMap;

@TabsAnnotation()
@TreeAnnotation()
@NavFoldingTreeAnnotation(caption = "流程监听器")
public class ListenerTypeTree extends TreeListItem {
    public ListenerTypeTree(String className, String projectName) {
        this.caption = "流程监听器";
        this.setId("DSMTempRoot");
        this.setIniFold(false);
        ListenerType[] listenerTypes = ListenerType.values();
        for (ListenerType type : listenerTypes) {
            this.addChild(new ListenerTypeTree(type, projectName, className));
        }
        this.addTagVar("projectName", projectName);
    }

    public ListenerTypeTree(ListenerType listenerType, String projectName, String className) {
        this.caption = listenerType.getName();
        this.imageClass = listenerType.getImageClass();
        this.setClassName(className);
        this.setId(listenerType.getType());
        this.setIniFold(false);
        this.tagVar = new HashMap<>();
        this.addTagVar("listenerType", listenerType.getType());
        this.addTagVar("projectName", projectName);
    }
}
