package com.ds.bpm.plugins.nav;

import com.ds.common.util.StringUtility;
import com.ds.config.TreeListResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.custom.annotation.TreeViewAnnotation;
import com.ds.esd.custom.module.annotation.ModuleAnnotation;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Controller
@RequestMapping("/admin/bpd/")
@MethodChinaName(cname = "流程定义配置", imageClass = "bpmfont bpm-gongzuoliu-moxing")
public class BPDManagerTree {
    @RequestMapping(method = RequestMethod.POST, value = "PluginNavTree")
    @ModuleAnnotation(dynLoad = true, caption = "工作流插件", imageClass = "bpmfont bpmgongzuoliuxitongpeizhi")
    @TreeViewAnnotation
    @ResponseBody
    public TreeListResultModel<List<PluginTypeTree>> getPlugins(String id, String projectVersionName) {
        TreeListResultModel<List<PluginTypeTree>> result = new TreeListResultModel<>();
        List<PluginTypeTree> plugins = new ArrayList<>();
        PluginTypeTree tree = new PluginTypeTree("admin.bpd.Plugins", projectVersionName);
        plugins.add(tree);
        if (id != null && !id.equals("")) {
            String[] orgIdArr = StringUtility.split(id, ";");
            result.setIds(Arrays.asList(orgIdArr));
        } else {
            result.setIds(Arrays.asList(new String[]{tree.getFristClassItem(tree).getId()}));
        }

        result.setData(plugins);

        return result;
    }


    @RequestMapping(method = RequestMethod.POST, value = "ListenerNavTree")
    @TreeViewAnnotation
    @ModuleAnnotation(dynLoad = true, imageClass = "spafont spa-icon-conf1", caption = "监听器")
    @ResponseBody
    public TreeListResultModel<List<ListenerTypeTree>> getListeners(String id, String projectVersionName) {
        TreeListResultModel<List<ListenerTypeTree>> result = new TreeListResultModel<>();
        List<ListenerTypeTree> plugins = new ArrayList<>();
        ListenerTypeTree tree = new ListenerTypeTree("admin.bpd.listener.Listeners", projectVersionName);
        plugins.add(tree);

        if (id != null && !id.equals("")) {
            String[] orgIdArr = StringUtility.split(id, ";");
            result.setIds(Arrays.asList(orgIdArr));
        } else {
            result.setIds(Arrays.asList(new String[]{tree.getFristClassItem(tree).getId()}));
        }

        result.setData(plugins);

        return result;
    }


}
