package com.ds.bpm.plugins.nav;

import com.ds.config.PluginType;
import com.ds.esd.custom.nav.annotation.TabsAnnotation;
import com.ds.esd.custom.tree.annotation.NavTreeAnnotation;
import com.ds.esd.custom.tree.annotation.TreeAnnotation;
import com.ds.esd.tool.ui.component.list.TreeListItem;

@TabsAnnotation()
@TreeAnnotation(caption = "工作流插件")
@NavTreeAnnotation(caption = "")
public class PluginTypeTree extends TreeListItem {

    public PluginTypeTree(String className, String projectName) {
        this.caption = "所有插件";
        this.setId("DSMTempRoot");
        this.setIniFold(false);
        PluginType[] pluginTypes = PluginType.values();
        for (PluginType type : pluginTypes) {
            this.addChild(new PluginTypeTree(type, projectName, className));
        }

        this.addTagVar("projectName", projectName);
    }

    public PluginTypeTree(PluginType pluginType, String projectName, String className) {
        this.caption = pluginType.getName();
        this.imageClass = pluginType.getImageClass();
        this.setClassName(className);
        this.setId(pluginType.getType());
        this.setIniFold(false);
        this.addTagVar("pluginType", pluginType.getType());
        this.addTagVar("projectName", projectName);

    }
}
