/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.cfg;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import org.wltea.analyzer.cfg.Configuration;

public class DefaultConfig
implements Configuration {
    private static final String PATH_DIC_MAIN = "main2012.dic";
    private static final String PATH_DIC_QUANTIFIER = "quantifier.dic";
    private static final String FILE_NAME = "IKAnalyzer.cfg.xml";
    private static final String EXT_DICT = "ext_dict";
    private static final String EXT_STOP = "ext_stopwords";
    private Properties props = new Properties();
    private boolean useSmart;

    public static Configuration getInstance() {
        return new DefaultConfig();
    }

    private DefaultConfig() {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(FILE_NAME);
        if (input != null) {
            try {
                this.props.loadFromXML(input);
            }
            catch (InvalidPropertiesFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean useSmart() {
        return this.useSmart;
    }

    @Override
    public void setUseSmart(boolean useSmart) {
        this.useSmart = useSmart;
    }

    @Override
    public String getMainDictionary() {
        return PATH_DIC_MAIN;
    }

    @Override
    public String getQuantifierDicionary() {
        return PATH_DIC_QUANTIFIER;
    }

    @Override
    public List<String> getExtDictionarys() {
        String[] filePaths;
        ArrayList<String> extDictFiles = new ArrayList<String>(2);
        String extDictCfg = this.props.getProperty(EXT_DICT);
        if (extDictCfg != null && (filePaths = extDictCfg.split(";")) != null) {
            for (String filePath : filePaths) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                extDictFiles.add(filePath.trim());
            }
        }
        return extDictFiles;
    }

    @Override
    public List<String> getExtStopWordDictionarys() {
        String[] filePaths;
        ArrayList<String> extStopWordDictFiles = new ArrayList<String>(2);
        String extStopWordDictCfg = this.props.getProperty(EXT_STOP);
        if (extStopWordDictCfg != null && (filePaths = extStopWordDictCfg.split(";")) != null) {
            for (String filePath : filePaths) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                extStopWordDictFiles.add(filePath.trim());
            }
        }
        return extStopWordDictFiles;
    }
}

