/*
 * Decompiled with CFR 0.152.
 */
package com.ds.index.sync;

import com.ds.common.util.IOUtility;
import com.ds.index.IndexFactory;
import com.ds.index.config.IndexConfigFactroy;
import com.ds.index.config.JLucene;
import com.ds.index.config.bean.JIndexWriter;
import com.ds.vfs.sync.SyncFactory;
import com.ds.web.RemoteConnectionManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.wltea.analyzer.lucene.IKAnalyzer;

public class IndexSyncLocal {
    private Path localDiskPath;
    private String vfsPath = "root/index/";
    private long syncDelayTime;
    private int maxTaskSize;
    static Map<String, List<Callable>> tasks = new HashMap<String, List<Callable>>();
    static Map<String, ReentrantLock> lockMap = new HashMap<String, ReentrantLock>();
    public static Map<String, IndexWriter> writerMap = new ConcurrentHashMap<String, IndexWriter>();
    public static Map<Path, List<Document>> indexDocMap = new ConcurrentHashMap<Path, List<Document>>();
    private static final Log logger = LogFactory.getLog(IndexSyncLocal.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ReentrantLock getLock(String path) {
        String string = path;
        synchronized (string) {
            ReentrantLock lock = lockMap.get(path);
            if (lock == null) {
                lock = new ReentrantLock();
                lockMap.put(path, lock);
            }
            return lock;
        }
    }

    public IndexSyncLocal(Path localDiskPath, long syncDelayTime, int maxTaskSize) {
        this.syncDelayTime = syncDelayTime;
        this.maxTaskSize = maxTaskSize;
        this.localDiskPath = localDiskPath;
    }

    private void copyStreamToFile(InputStream input, File file) throws IOException {
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists() && !file.canWrite()) {
            String message = "Unable to open file " + file + " for writing.";
            throw new IOException(message);
        }
        FileOutputStream output = new FileOutputStream(file);
        IOUtility.copy((InputStream)input, (OutputStream)output);
        IOUtility.shutdownStream((InputStream)input);
        IOUtility.shutdownStream((OutputStream)output);
    }

    public Analyzer getAnalyzer(Class clazz) {
        IKAnalyzer analyzer = null;
        analyzer = new IKAnalyzer();
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexWriter getIndexWriter(JLucene lucene) {
        String wpath;
        String path = lucene.getFsDirectory().getPath();
        String id = lucene.getFsDirectory().getId();
        String string = wpath = id + "[" + path + "]";
        synchronized (string) {
            IndexWriter writer = writerMap.get(wpath);
            if (writer == null) {
                JIndexWriter jIndexWriter = lucene.getIndexWriter();
                Directory dir = null;
                try {
                    dir = IndexFactory.getFSDirectory(lucene.getFsDirectory());
                    Class analyzerClass = lucene.getIndexWriter().getAnalyzer();
                    Analyzer analyzer = this.getAnalyzer(analyzerClass);
                    IndexWriterConfig cfg = new IndexWriterConfig(analyzer);
                    IndexWriterConfig.OpenMode openMode = jIndexWriter.getOpenMode();
                    cfg.setOpenMode(openMode);
                    writer = new IndexWriter(dir, cfg);
                    writerMap.put(wpath, writer);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!writer.isOpen()) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                writer = this.getIndexWriter(lucene);
            }
            return writer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndex(Query query, JLucene luceneBean) throws IOException {
        String string = luceneBean.getFsDirectory().getPath();
        synchronized (string) {
            IndexWriter writer = this.getIndexWriter(luceneBean);
            ScheduledExecutorService service = SyncFactory.getLocalService((Path)this.localDiskPath);
            writer.deleteDocuments(new Query[]{query});
            try {
                if (writer != null && writer.isOpen()) {
                    writer.commit();
                    writer.flush();
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndex(JLucene luceneBean) throws IOException {
        String string = luceneBean.getFsDirectory().getPath();
        synchronized (string) {
            IndexWriter writer = this.getIndexWriter(luceneBean);
            ScheduledExecutorService service = SyncFactory.getLocalService((Path)this.localDiskPath);
            writer.deleteDocuments(new Term[]{new Term(IndexConfigFactroy.uuid, luceneBean.getUuid())});
            try {
                if (writer != null && writer.isOpen()) {
                    writer.commit();
                    writer.flush();
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public JLucene pushIndex(JLucene luceneBean, Document document) throws IOException {
        String path = luceneBean.getFsDirectory().getPath();
        ReentrantLock lock = IndexSyncLocal.getLock(path);
        ExecutorService service = RemoteConnectionManager.getConntctionService((String)path);
        service.submit(new UpdateIndexTask(this, document, luceneBean, lock));
        return luceneBean;
    }

    public static String getFolderPath(String path) {
        path = path.replaceAll("\\\\", "/");
        path = path.replaceAll("//", "/");
        String[] paths = path.split("/");
        String folderPath = "";
        for (int i = 0; i < paths.length - 1; ++i) {
            folderPath = folderPath + paths[i] + "/";
        }
        return folderPath;
    }

    public static String formartPath(String path) {
        path = path.replaceAll("\\\\", "/");
        if (!(path = path.replaceAll("//", "/")).endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public static void main(String[] args) throws IOException {
        ReentrantLock lock = new ReentrantLock();
        lock.tryLock();
    }

    static class UpdateIndexTask<T extends JLucene>
    implements Callable<JLucene> {
        private final ReentrantLock lock;
        public T luceneBean;
        Document document;
        final /* synthetic */ IndexSyncLocal this$0;

        public UpdateIndexTask(Document document, T luceneBean, ReentrantLock lock) {
            this.this$0 = this$0;
            this.document = document;
            this.luceneBean = luceneBean;
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() {
            try {
                while (!this.lock.isLocked()) {
                    this.lock.tryLock();
                    logger.info((Object)("start log index by Lucene" + this.luceneBean.getJson()));
                    IndexWriter writer = this.this$0.getIndexWriter(this.luceneBean);
                    IndexableField indexField = this.document.getField(IndexConfigFactroy.uuid);
                    if (this.document.getField(IndexConfigFactroy.uuid) == null || this.document.getField(IndexConfigFactroy.uuid).stringValue().equals("")) {
                        String uuid = UUID.randomUUID().toString();
                        this.luceneBean.setUuid(uuid);
                        indexField = new StringField(IndexConfigFactroy.uuid, uuid, Field.Store.YES);
                        this.document.add(indexField);
                        StoredField createStoredField = new StoredField(IndexConfigFactroy.createtime, System.currentTimeMillis());
                        this.document.add((IndexableField)new NumericDocValuesField(IndexConfigFactroy.createtime, System.currentTimeMillis()));
                        this.document.add((IndexableField)createStoredField);
                        StoredField updateStoredField = new StoredField(IndexConfigFactroy.updatetime, System.currentTimeMillis());
                        this.document.add((IndexableField)updateStoredField);
                        this.document.add((IndexableField)new NumericDocValuesField(IndexConfigFactroy.updatetime, System.currentTimeMillis()));
                        writer.addDocument((Iterable)this.document);
                    } else {
                        StoredField updateTimeField = new StoredField(IndexConfigFactroy.updatetime, System.currentTimeMillis());
                        this.document.add((IndexableField)updateTimeField);
                        this.document.add((IndexableField)new NumericDocValuesField(IndexConfigFactroy.updatetime, System.currentTimeMillis()));
                        writer.updateDocument(new Term(IndexConfigFactroy.uuid, indexField.stringValue()), (Iterable)this.document);
                    }
                    if (writer == null || !writer.isOpen()) continue;
                    writer.commit();
                    writer.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (this.lock.isLocked()) {
                    this.lock.unlock();
                }
            }
            return this.luceneBean;
        }
    }
}

