/*
 * Decompiled with CFR 0.152.
 */
package com.ds.index;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import com.ds.common.JDSException;
import com.ds.common.cache.Cache;
import com.ds.common.cache.CacheManagerFactory;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.md5.MD5;
import com.ds.common.md5.MD5InputStream;
import com.ds.common.query.Condition;
import com.ds.common.query.ConditionKey;
import com.ds.common.query.JLuceneIndex;
import com.ds.common.query.Order;
import com.ds.common.util.DateUtility;
import com.ds.config.JDSConfig;
import com.ds.config.ListResultModel;
import com.ds.index.config.IndexConfigFactroy;
import com.ds.index.config.JLucene;
import com.ds.index.config.JLuceneBean;
import com.ds.index.config.bean.JFSDirectory;
import com.ds.index.config.bean.JField;
import com.ds.index.sync.IndexSyncLocal;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.vfs.FileInfo;
import com.ds.vfs.ct.CtVfsFactory;
import com.ds.vfs.ct.CtVfsService;
import com.ds.vfs.index.FileIndex;
import com.ds.vfs.service.VFSClientService;
import com.ds.vfs.sync.SyncFactory;
import com.ds.web.RemoteConnectionManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import net.sf.cglib.beans.BeanMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.uhighlight.DefaultPassageFormatter;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.PassageScorer;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.wltea.analyzer.lucene.IKAnalyzer;

public class IndexFactory {
    public static final String THREAD_LOCK = "Thread Lock";
    private static IndexFactory instance;
    private static final String LineNumName = "lineNum";
    private static final String PahtName = "path";
    public static final Log logger;
    private static final SerializeConfig config;
    private final Cache<String, String> indexCache;
    private Map<Path, IndexSyncLocal> localMap = new HashMap<Path, IndexSyncLocal>();
    private IndexConfigFactroy configFactory = IndexConfigFactroy.getInstance();
    private SyncFactory syncFactory = SyncFactory.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IndexFactory getInstance() {
        if (instance != null) return instance;
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            if (instance != null) return instance;
            instance = new IndexFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    IndexFactory() {
        this.indexCache = CacheManagerFactory.createCache((String)"JDS", (String)"IndexCache", (int)0x6400000, (long)600000L);
    }

    public JLuceneBean getIndexByPath(String path) {
        String json = (String)this.indexCache.get((Object)path);
        JLuceneBean jLucene = null;
        if (json != null && !json.equals("")) {
            jLucene = (JLuceneBean)JSONObject.parseObject((String)json, JLuceneBean.class);
        }
        return jLucene;
    }

    public void removeIndexPath(String path) {
        this.indexCache.remove((Object)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IndexSyncLocal getIndexSyncLocal(Path path, Long delayTime, int maxTaskSize) {
        IndexSyncLocal sync = this.localMap.get(path);
        if (sync != null) return sync;
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            sync = new IndexSyncLocal(path, delayTime, maxTaskSize);
            this.localMap.put(path, sync);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return sync;
        }
    }

    private List<Field> getIndexField(JField fieldBean) {
        ArrayList<Field> fields = new ArrayList<Field>();
        StringField indexField = null;
        Class clazz = fieldBean.getClazz();
        String name = fieldBean.getName();
        Field.Store store = fieldBean.getStore();
        Object value = fieldBean.getValue();
        StoredField soredField = null;
        if (store.equals((Object)Field.Store.YES)) {
            soredField = new StoredField(name, value == null ? "" : value.toString());
        }
        if (String.class.isAssignableFrom(clazz)) {
            indexField = new StringField(fieldBean.getName(), value == null ? "" : value.toString(), store);
            fields.add((Field)indexField);
        } else if (Long.class.isAssignableFrom(clazz)) {
            indexField = new LongPoint(name, new long[]{Long.valueOf(value == null ? "0" : value.toString())});
            fields.add((Field)indexField);
            if (soredField != null) {
                fields.add((Field)soredField);
            }
        } else if (Integer.class.isAssignableFrom(clazz)) {
            indexField = new IntPoint(name, new int[]{Integer.valueOf(value == null ? "0" : value.toString())});
            fields.add((Field)indexField);
            if (soredField != null) {
                fields.add((Field)soredField);
            }
        } else if (Float.class.isAssignableFrom(clazz)) {
            indexField = new FloatPoint(name, new float[]{Float.valueOf(value == null ? "0" : value.toString()).floatValue()});
            fields.add((Field)indexField);
            if (soredField != null) {
                fields.add((Field)soredField);
            }
        } else if (Double.class.isAssignableFrom(clazz)) {
            indexField = new DoublePoint(name, new double[]{Double.valueOf(value == null ? "0" : value.toString())});
            fields.add((Field)indexField);
            if (soredField != null) {
                fields.add((Field)soredField);
            }
        } else if (StringBuffer.class.isAssignableFrom(clazz)) {
            indexField = new TextField(name, value == null ? "" : value.toString(), store);
            fields.add((Field)indexField);
        } else {
            indexField = new StoredField(name, value == null ? "" : value.toString());
            fields.add((Field)indexField);
        }
        return fields;
    }

    public <V extends JLuceneIndex, T extends ConditionKey> void deleteIndex(JLucene luceneBean) throws IOException {
        String pathStr = luceneBean.getFsDirectory().getPath();
        Path path = Paths.get(JDSConfig.Config.dataPath().getAbsolutePath() + File.separator + pathStr, new String[0]);
        IndexSyncLocal sync = this.getIndexSyncLocal(path, luceneBean.getFsDirectory().getSyncDelayTime(), luceneBean.getFsDirectory().getMaxTaskSize());
        if (sync != null) {
            sync.removeIndex(luceneBean);
        }
    }

    public <V extends JLuceneIndex, T extends ConditionKey> void deleteIndex(Condition<T, V> condition) throws IOException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Query query = this.getQuery(null, condition);
        JLucene luceneBean = this.configFactory.getJLuceneConfig(condition.getIndex());
        String pathStr = luceneBean.getFsDirectory().getPath();
        Path path = Paths.get(JDSConfig.Config.dataPath().getAbsolutePath() + File.separator + pathStr, new String[0]);
        IndexSyncLocal sync = this.getIndexSyncLocal(path, luceneBean.getFsDirectory().getSyncDelayTime(), luceneBean.getFsDirectory().getMaxTaskSize());
        if (sync != null) {
            sync.removeIndex(query, luceneBean);
        }
    }

    public JLucene addIndexBean(JLucene luceneBean) {
        return this.addIndexBean(luceneBean, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JLucene addIndexBean(JLucene luceneBean, boolean wait) {
        IndexSyncLocal sync = null;
        Integer lineNum = 0;
        if (luceneBean.getVfsFilePaths() != null && luceneBean.getVfsFilePaths().size() > 0 && wait) {
            List paths = luceneBean.getVfsFilePaths();
            for (String path : paths) {
                this.indexCache.put((Object)path, (Object)JSONObject.toJSONString((Object)luceneBean, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]));
            }
            return luceneBean;
        }
        String json = luceneBean.getJson();
        String fileName = luceneBean.getVfsJson().getFileName();
        String vfsPath = luceneBean.getFsDirectory().getVfsPath();
        if (luceneBean.isVfsValid()) {
            // empty if block
        }
        if (luceneBean.isIndexValid()) {
            try {
                Document doc = new Document();
                List fields = luceneBean.getFields();
                for (JField fieldBean : fields) {
                    List<Field> indexFields = this.getIndexField(fieldBean);
                    for (Field field : indexFields) {
                        doc.add((IndexableField)field);
                    }
                }
                if (luceneBean.isVfsValid()) {
                    StringField vfsUrlField = new StringField(PahtName, vfsPath + "/" + fileName, Field.Store.YES);
                    doc.add((IndexableField)vfsUrlField);
                }
                if (luceneBean.getJson() != null && !luceneBean.getJson().equals("")) {
                    StringField jsonField = new StringField(IndexConfigFactroy.jsonkey, luceneBean.getJson(), Field.Store.YES);
                    doc.add((IndexableField)jsonField);
                }
                String pathStr = luceneBean.getFsDirectory().getPath();
                Path path = Paths.get(JDSConfig.Config.dataPath().getAbsolutePath() + File.separator + pathStr, new String[0]);
                sync = this.getIndexSyncLocal(path, luceneBean.getFsDirectory().getSyncDelayTime(), luceneBean.getFsDirectory().getMaxTaskSize());
                if (sync != null) {
                    luceneBean = sync.pushIndex(luceneBean, doc);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return luceneBean;
    }

    public void addFileIndex(FileInfo fileInfo, String text) {
        JLuceneBean bean = this.getIndexByPath(fileInfo.getPath());
        if (bean == null) {
            FileIndex fileIndex = new FileIndex(fileInfo);
            fileIndex.setText(new StringBuffer(text));
            IndexFactory.getInstance().addIndex((JLuceneIndex)fileIndex);
        } else {
            this.removeIndexPath(fileInfo.getPath());
            List fields = bean.getFields();
            for (JField jField : fields) {
                if (!jField.getName().equals("text")) continue;
                jField.setValue((Object)text);
            }
            IndexFactory.getInstance().addIndexBean((JLucene)bean, false);
        }
    }

    public JLuceneIndex addIndex(JLuceneIndex index, Map valueMap) {
        logger.info((Object)("start index " + JSONObject.toJSON((Object)index).toString()));
        try {
            JLucene luceneBean = this.configFactory.getJLuceneConfig(index);
            luceneBean.setUserId(index.getUserId());
            String json = JSONObject.toJSONString((Object)index);
            luceneBean.setJson(json);
            luceneBean = this.addIndexBean(luceneBean);
            index.setUuid(luceneBean.getUuid());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return index;
    }

    public JLuceneIndex addIndex(JLuceneIndex index) {
        logger.info((Object)("start index " + JSONObject.toJSON((Object)index).toString()));
        try {
            JLucene luceneBean = this.configFactory.getJLuceneConfig(index);
            luceneBean.setUserId(index.getUserId());
            String json = JSONObject.toJSONString((Object)index);
            luceneBean.setJson(json);
            luceneBean = this.addIndexBean(luceneBean);
            index.setUuid(luceneBean.getUuid());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return index;
    }

    private void initTempPath(String tempPath) {
        Path path = Paths.get(tempPath, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                path = Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File newLocalFile(String tempPath, String json) throws IOException {
        FileWriter fw = null;
        BufferedWriter writer = null;
        this.initTempPath(tempPath);
        File localFile = new File(tempPath + ".temp");
        try {
            if (!localFile.exists()) {
                localFile.createNewFile();
            }
            fw = new FileWriter(localFile);
            writer = new BufferedWriter(fw);
            writer.write(json);
            writer.newLine();
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (fw != null) {
                fw.close();
            }
        }
        return localFile;
    }

    public static Directory getFSDirectory(JFSDirectory fsDirectory) throws IOException {
        SimpleFSDirectory directory = null;
        Class clazz = fsDirectory.getFsDirectoryClass();
        String pathStr = fsDirectory.getPath();
        Path path = Paths.get(JDSConfig.Config.dataPath().getAbsolutePath() + File.separator + pathStr, new String[0]);
        Files.createDirectories(path, new FileAttribute[0]);
        if (SimpleFSDirectory.class.isAssignableFrom(clazz)) {
            directory = new SimpleFSDirectory(path);
        } else if (MMapDirectory.class.isAssignableFrom(clazz)) {
            directory = new MMapDirectory(path);
        } else if (NIOFSDirectory.class.isAssignableFrom(clazz)) {
            directory = new NIOFSDirectory(path);
        } else if (MMapDirectory.class.isAssignableFrom(clazz)) {
            directory = new MMapDirectory(path);
        } else if (Long.class.isAssignableFrom(clazz)) {
            directory = new MMapDirectory(path);
        } else {
            FSLockFactory lockFatory = SimpleFSLockFactory.getDefault();
            directory = new RAMDirectory((LockFactory)lockFatory);
        }
        return directory;
    }

    private void updateRemote(String userId, String vfsPath, String fileName, String json) {
        ExecutorService remoteService = RemoteConnectionManager.getConntctionService((String)"updateRemote");
        remoteService.execute(new UpdateRemoteTask(userId, vfsPath, fileName, json));
    }

    private <T extends JLuceneIndex> T newIndex(Class<?> tClass) {
        ArrayList classes = new ArrayList();
        classes.addAll(Arrays.asList(tClass.getInterfaces()));
        if (tClass.isInterface()) {
            classes.add(tClass);
        }
        MethodInterceptor staticMethodInterceptor = new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] objects, MethodProxy proxy) {
                String name = method.getName();
                Object returnobj = null;
                try {
                    returnobj = method.invoke(returnobj, objects);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return returnobj;
            }
        };
        JLuceneIndex obj = (JLuceneIndex)Enhancer.create(tClass, (Class[])classes.toArray(new Class[classes.size()]), (Callback)staticMethodInterceptor);
        return (T)obj;
    }

    private <V extends JLuceneIndex, T extends ConditionKey> Sort getSort(Condition<T, V> condition) {
        List orderList = condition.getOrderByList();
        ArrayList<SortField> sorts = new ArrayList<SortField>();
        Sort mainsort = new Sort();
        for (Order order : orderList) {
            SortField sortfield = new SortField(order.getKey().toString(), SortField.Type.LONG, order.isAsc());
            sorts.add(sortfield);
        }
        SortField createtimesortfield = new SortField(IndexConfigFactroy.updatetime, SortField.Type.LONG, true);
        sorts.add(createtimesortfield);
        mainsort.setSort(sorts.toArray(new SortField[sorts.size()]));
        return mainsort;
    }

    private <V extends JLuceneIndex, T extends ConditionKey> Query getQuery(Query query, Condition<T, V> condition) {
        BooleanQuery.Builder booQuery = new BooleanQuery.Builder();
        if (query == null) {
            QueryParser parse = new QueryParser(PahtName, (Analyzer)new IKAnalyzer());
            parse.setAllowLeadingWildcard(true);
            try {
                query = parse.parse("*");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            booQuery.add(query, BooleanClause.Occur.MUST);
        } else {
            booQuery.add(query, BooleanClause.Occur.MUST);
        }
        if (condition.getValue() != null) {
            switch (condition.getOperator()) {
                case EQUALS: {
                    Term term = new Term(condition.getConditionKey().toString(), condition.getValue().toString());
                    TermQuery termQuery = new TermQuery(term);
                    booQuery.add((Query)termQuery, BooleanClause.Occur.MUST);
                    break;
                }
                case NOT_EQUAL: {
                    Term term = new Term(condition.getConditionKey().toString(), condition.getValue().toString());
                    TermQuery termQuery = new TermQuery(term);
                    booQuery.add((Query)termQuery, BooleanClause.Occur.MUST_NOT);
                    break;
                }
                case LESS_THAN: {
                    query = LongPoint.newRangeQuery((String)condition.getConditionKey().toString(), (long)Long.MIN_VALUE, (long)Long.valueOf(condition.getValue().toString()));
                    booQuery.add(query, BooleanClause.Occur.MUST);
                    break;
                }
                case GREATER_THAN: {
                    query = LongPoint.newRangeQuery((String)condition.getConditionKey().toString(), (long)Long.valueOf(condition.getValue().toString()), (long)Long.MAX_VALUE);
                    booQuery.add(query, BooleanClause.Occur.MUST);
                    break;
                }
                case LESS_THAN_EQUAL_TO: {
                    query = LongPoint.newRangeQuery((String)condition.getConditionKey().toString(), (long)Long.MIN_VALUE, (long)Long.valueOf(condition.getValue().toString()));
                    booQuery.add(query, BooleanClause.Occur.MUST);
                    break;
                }
                case GREATER_THAN_EQUAL_TO: {
                    query = LongPoint.newRangeQuery((String)condition.getConditionKey().toString(), (long)Long.valueOf(condition.getValue().toString()), (long)Long.MAX_VALUE);
                    booQuery.add(query, BooleanClause.Occur.MUST);
                    break;
                }
                case LIKE: {
                    QueryParser parse = new QueryParser(condition.getConditionKey().toString(), (Analyzer)new IKAnalyzer());
                    parse.setAllowLeadingWildcard(true);
                    try {
                        query = parse.parse("*" + condition.getValue().toString() + "*");
                        booQuery.add(query, BooleanClause.Occur.MUST);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case IN: {
                    Iterator ite;
                    QueryParser parse = new QueryParser(condition.getConditionKey().toString(), (Analyzer)new IKAnalyzer());
                    Object value = condition.getValue();
                    StringBuffer sb = new StringBuffer();
                    if (value instanceof Collection) {
                        ite = ((Collection)value).iterator();
                        boolean first = true;
                        while (ite.hasNext()) {
                            if (first) {
                                first = false;
                            } else {
                                sb.append(" ");
                            }
                            sb.append(condition.extractValue(ite.next()));
                        }
                    } else if (value instanceof String) {
                        sb.append((String)value);
                    }
                    try {
                        query = parse.parse(sb.toString());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    booQuery.add(query, BooleanClause.Occur.MUST);
                    break;
                }
                case NOT_IN: {
                    Iterator ite;
                    QueryParser parse = new QueryParser(condition.getConditionKey().toString(), (Analyzer)new IKAnalyzer());
                    Object value = condition.getValue();
                    StringBuffer sb = new StringBuffer();
                    if (value instanceof Collection) {
                        ite = ((Collection)value).iterator();
                        boolean first = true;
                        while (ite.hasNext()) {
                            if (first) {
                                first = false;
                            } else {
                                sb.append(" ");
                            }
                            sb.append(condition.extractValue(ite.next()));
                        }
                    } else if (value instanceof String) {
                        sb.append((String)value);
                    }
                    try {
                        query = parse.parse(sb.toString());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    booQuery.add(query, BooleanClause.Occur.MUST_NOT);
                    break;
                }
                case BETWEEN: {
                    Collection valueCol;
                    Object value = condition.getValue();
                    if (!(value instanceof Collection) || (valueCol = (Collection)value).size() < 2) break;
                    Iterator ite = valueCol.iterator();
                    query = LongPoint.newRangeQuery((String)condition.getConditionKey().toString(), (long)Long.valueOf(ite.next().toString()), (long)Long.valueOf(ite.next().toString()));
                    booQuery.add(query, BooleanClause.Occur.MUST);
                    break;
                }
                case NULL: {
                    QueryParser parse = new QueryParser(condition.getConditionKey().toString(), (Analyzer)new IKAnalyzer());
                    try {
                        query = parse.parse("-" + condition.getConditionKey().toString() + ":[* TO *]");
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    booQuery.add(query, BooleanClause.Occur.MUST);
                    break;
                }
            }
        }
        List msgConditions = condition.getChildConditionList();
        query = booQuery.build();
        for (Condition childcondition : msgConditions) {
            query = this.getQuery(query, childcondition);
        }
        return query;
    }

    public static UnifiedHighlighter buildHighlighter(IndexSearcher searcher, Analyzer chAnalyzer) {
        DefaultPassageFormatter passageFormatter = new DefaultPassageFormatter();
        PassageScorer score = new PassageScorer();
        UnifiedHighlighter uniHighlighter = new UnifiedHighlighter(searcher, chAnalyzer);
        uniHighlighter.setFormatter((PassageFormatter)passageFormatter);
        uniHighlighter.setScorer(score);
        return uniHighlighter;
    }

    public <V extends JLuceneIndex, T extends ConditionKey> ListResultModel<List<V>> search(Condition<T, V> condition) {
        Query query = this.getQuery(null, condition);
        Sort srot = this.getSort(condition);
        return this.search(condition.getIndex(), query, srot, condition.getPage().getPageSize(), condition.getPage().getPageIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends JLuceneIndex, T extends ConditionKey> ListResultModel<List<V>> search(V index, Query query, Sort sort, Integer pageSize, Integer pageIndex) {
        JLucene lucene = null;
        Directory dir = null;
        DirectoryReader reader = null;
        ArrayList<JLuceneIndex> indexList = new ArrayList<JLuceneIndex>();
        ListResultModel result = new ListResultModel();
        try {
            lucene = this.configFactory.getJLuceneConfig(index);
            dir = IndexFactory.getFSDirectory(lucene.getFsDirectory());
            reader = DirectoryReader.open((Directory)dir);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            Integer count = searcher.count(query);
            if (pageSize == null || pageSize.equals("")) {
                pageSize = 20;
            }
            if (pageIndex < 1) {
                pageIndex = 1;
            }
            int start = (pageIndex - 1) * pageSize;
            int end = pageSize * pageIndex;
            if (end > count) {
                end = count;
            }
            result.setSize(count.intValue());
            if (count > 0) {
                TopFieldDocs topDocs = searcher.search(query, end, sort);
                DefaultPassageFormatter passageFormatter = new DefaultPassageFormatter();
                Map contentHigh = new HashMap();
                String[] highField = lucene.getHighFields().toArray(new String[0]);
                if (highField.length > 0) {
                    UnifiedHighlighter uniHighlighter = IndexFactory.buildHighlighter(searcher, new IKAnalyzer());
                    uniHighlighter.setFormatter((PassageFormatter)passageFormatter);
                    contentHigh = uniHighlighter.highlightFields(highField, query, (TopDocs)topDocs);
                }
                for (int i = start; i < end; ++i) {
                    String value;
                    BeanMap beanMap;
                    int docId = topDocs.scoreDocs[i].doc;
                    Document doc = searcher.doc(docId);
                    List fields = doc.getFields();
                    JLuceneIndex newindex = null;
                    String jsonVlaue = null;
                    for (IndexableField field : fields) {
                        if (!field.name().equals(IndexConfigFactroy.jsonkey)) continue;
                        jsonVlaue = field.stringValue();
                    }
                    if (jsonVlaue == null) {
                        newindex = (JLuceneIndex)BeanUtils.cloneBean(index);
                        beanMap = BeanMap.create((Object)newindex);
                        beanMap.put((Object)IndexConfigFactroy.uuid, (Object)doc.getField(IndexConfigFactroy.uuid).stringValue());
                        for (IndexableField field : fields) {
                            value = field.stringValue();
                            if (contentHigh.get(field.name()) != null && ((String[])contentHigh.get(field.name()))[i] != null) {
                                value = ((String[])contentHigh.get(field.name()))[i];
                            }
                            if (Date.class.isAssignableFrom(beanMap.getPropertyType(field.name()))) {
                                beanMap.put((Object)field.name(), (Object)DateUtility.getDate((String)value));
                                continue;
                            }
                            if (StringBuffer.class.isAssignableFrom(beanMap.getPropertyType(field.name()))) {
                                beanMap.put((Object)field.name(), (Object)new StringBuffer(value));
                                continue;
                            }
                            if (value.equals("")) continue;
                            Object obj = TypeUtils.cast((Object)value, (Class)beanMap.getPropertyType(field.name()), null);
                            beanMap.put((Object)field.name(), obj);
                        }
                    } else {
                        newindex = (JLuceneIndex)JSONObject.parseObject(jsonVlaue, index.getClass());
                        beanMap = BeanMap.create((Object)newindex);
                        beanMap.put((Object)IndexConfigFactroy.uuid, (Object)doc.getField(IndexConfigFactroy.uuid).stringValue());
                        for (IndexableField field : fields) {
                            value = field.stringValue();
                            if (contentHigh.get(field.name()) == null || ((String[])contentHigh.get(field.name()))[i] == null) continue;
                            value = ((String[])contentHigh.get(field.name()))[i];
                            if (StringBuffer.class.isAssignableFrom(beanMap.getPropertyType(field.name()))) {
                                beanMap.put((Object)field.name(), (Object)new StringBuffer(value));
                                continue;
                            }
                            beanMap.put((Object)field.name(), (Object)value);
                        }
                    }
                    indexList.add(newindex);
                }
            }
            result.setData(indexList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public VFSClientService getVfsService() {
        VFSClientService client = (VFSClientService)EsbUtil.parExpression((String)"$VFSClientService");
        return client;
    }

    public static void main(String[] args) {
    }

    static {
        logger = LogFactory.getLog((String)"JDS", IndexFactory.class);
        config = new SerializeConfig();
        IndexFactory.config.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }

    class UpdateRemoteTask
    implements Runnable {
        private final String json;
        private String vfsPath;
        private String fileName;

        public UpdateRemoteTask(String userId, String vfsPath, String fileName, String json) {
            this.vfsPath = vfsPath;
            this.fileName = fileName;
            this.json = json;
        }

        @Override
        public void run() {
            Integer ln = 0;
            CtVfsService service = CtVfsFactory.getCtVfsService();
            if (!this.vfsPath.endsWith("/")) {
                this.vfsPath = this.vfsPath + "/";
            }
            String filePath = this.vfsPath + this.fileName;
            FileInfo file = null;
            try {
                file = service.getFileByPath(filePath);
            }
            catch (JDSException jDSException) {
                // empty catch block
            }
            try {
                if (file == null) {
                    file = service.createFile(this.vfsPath, this.fileName);
                    File localFile = IndexFactory.this.newLocalFile(IndexFactory.this.configFactory.getTempRootPath() + File.separator + MD5.getHashString((String)this.json), this.json);
                    service.upload(file.getPath(), new MD5InputStream((InputStream)new FileInputStream(localFile)), null);
                    localFile.deleteOnExit();
                } else {
                    ln = service.writeLine(file.getCurrentVersonId(), this.json);
                    if (ln == -1) {
                        File localFile = IndexFactory.this.newLocalFile(IndexFactory.this.configFactory.getTempRootPath() + File.separator + MD5.getHashString((String)this.json), this.json);
                        service.upload(file.getPath(), new MD5InputStream((InputStream)new FileInputStream(localFile)), null);
                        localFile.deleteOnExit();
                        ln = 0;
                    }
                }
            }
            catch (JDSException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

