/*
 * Decompiled with CFR 0.152.
 */
package com.ds.vfs.index;

import com.alibaba.fastjson.annotation.JSONField;
import com.ds.index.config.type.FSDirectoryType;
import com.ds.index.config.type.JDocumentType;
import com.ds.index.config.type.JFieldType;
import com.ds.index.config.type.JIndexWriterType;
import com.ds.index.config.type.VFSJsonType;
import com.ds.vfs.FileInfo;
import com.ds.vfs.index.VFSIndex;
import org.apache.lucene.document.Field;

@JDocumentType(name="VfsFileIndex", fsDirectory=@FSDirectoryType(id="VfsFileIndex"), vfsJson=@VFSJsonType(vfsPath="doc/log/", fileName="vfsLog.js"), indexWriter=@JIndexWriterType(id="vfsLogIndex"))
public class FileIndex
implements VFSIndex {
    @JFieldType(store=Field.Store.YES)
    String name;
    @JFieldType(store=Field.Store.YES)
    String userId;
    @JFieldType(store=Field.Store.YES, highlighter=true)
    StringBuffer text = new StringBuffer();
    @JFieldType(store=Field.Store.YES)
    String desc;
    @JFieldType(store=Field.Store.YES)
    String right;
    @JFieldType(store=Field.Store.YES)
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    Long createtime;
    @JFieldType(store=Field.Store.YES)
    String docpath;
    String path = "VfsFileIndex";
    String uuid;

    @Override
    public String getDocpath() {
        return this.docpath;
    }

    @Override
    public void setDocpath(String docpath) {
        this.docpath = docpath;
    }

    public FileIndex() {
    }

    public FileIndex(FileInfo fileInfo) {
        this.name = fileInfo.getName();
        this.userId = fileInfo.getPersonId();
        this.docpath = fileInfo.getPath();
        this.createtime = fileInfo.getCreateTime();
        this.right = fileInfo.getRight();
        this.desc = fileInfo.getDescrition();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public StringBuffer getText() {
        return this.text;
    }

    @Override
    public void setText(StringBuffer text) {
        this.text = text;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String getRight() {
        return this.right;
    }

    @Override
    public void setRight(String right) {
        this.right = right;
    }

    @Override
    public Long getCreatetime() {
        return this.createtime;
    }

    @Override
    public void setCreatetime(Long createtime) {
        this.createtime = createtime;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPath() {
        return this.path;
    }
}

