/*
 * Decompiled with CFR 0.152.
 */
package com.ds.index.listener;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;

public class FileSyncListener
implements Runnable {
    private String path;
    private String vfsPath;

    public FileSyncListener(String path, String vfsPath) {
        this.vfsPath = vfsPath;
        this.path = path;
    }

    void addListener(String path) {
        Path myDir = Paths.get(path, new String[0]);
        try {
            WatchService watcher = myDir.getFileSystem().newWatchService();
            myDir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            WatchKey watckKey = watcher.take();
            List<WatchEvent<?>> events = watckKey.pollEvents();
            for (WatchEvent<?> event : events) {
                if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                    System.out.println("Created: " + event.context().toString());
                }
                if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                    System.out.println("Delete: " + event.context().toString());
                }
                if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                System.out.println("Modify: " + event.context().toString());
            }
            this.addListener(path);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.toString());
        }
    }

    @Override
    public void run() {
        this.addListener(this.path);
    }
}

