/*
 * Decompiled with CFR 0.152.
 */
package com.ds.index.config;

import com.alibaba.fastjson.JSONObject;
import com.ds.annotation.ClassMappingAnnotation;
import com.ds.annotation.JLuceneIndex;
import com.ds.config.JDSConfig;
import com.ds.index.config.JLucene;
import com.ds.index.config.JLuceneBean;
import com.ds.index.config.bean.JDocument;
import com.ds.index.config.bean.JFSDirectory;
import com.ds.index.config.bean.JField;
import com.ds.index.config.bean.JFieldBean;
import com.ds.index.config.bean.JIndexBean;
import com.ds.index.config.bean.JPath;
import com.ds.index.config.bean.VFSJsonBean;
import com.ds.index.config.type.JDocumentType;
import com.ds.index.config.type.JFieldType;
import com.ds.index.config.type.JPathType;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;
import org.apache.lucene.document.Field;

public class IndexConfigFactroy {
    static String vfsRootPath = "cdiskroot/";
    public static String jsonkey = "JSONVALUE#";
    public static String createtime = "createtime";
    public static String updatetime = "updatetime";
    public static String uuid = "uuid";
    public static String indexRootPathStr = "index";
    public static String tempRootPathStr = "temp";
    private static final String THREAD_LOCK = "Thread Lock";
    private static IndexConfigFactroy instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IndexConfigFactroy getInstance() {
        if (instance != null) return instance;
        String string = THREAD_LOCK;
        synchronized (THREAD_LOCK) {
            if (instance != null) return instance;
            instance = new IndexConfigFactroy();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    IndexConfigFactroy() {
        this.initPath(Paths.get(JDSConfig.Config.dataPath().getAbsolutePath() + File.separator + indexRootPathStr, new String[0]));
        this.initPath(Paths.get(JDSConfig.Config.dataPath().getAbsolutePath() + File.separator + tempRootPathStr, new String[0]));
    }

    private void initPath(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                path = Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Path getIndexRootPath() {
        return Paths.get(JDSConfig.Config.dataPath().getAbsolutePath() + File.separator + indexRootPathStr, new String[0]);
    }

    public Path getTempRootPath() {
        return Paths.get(JDSConfig.Config.dataPath().getAbsolutePath() + File.separator + tempRootPathStr, new String[0]);
    }

    public JLucene getJLuceneConfig(JLuceneIndex luceneIndex, Map valueMap) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        JLuceneBean luceneConfig = new JLuceneBean();
        Class<?> clazz = luceneIndex.getClass();
        JDocumentType annotation = clazz.getAnnotation(JDocumentType.class);
        JDocument document = null;
        try {
            Field[] fields;
            document = (JDocument)this.getIndexBean(annotation);
            luceneConfig.setVfsValid(document.isVfsValid());
            luceneConfig.setIndexValid(document.isIndexValid());
            String json = JSONObject.toJSONString((Object)luceneIndex);
            luceneConfig.setJson(json);
            JFSDirectory fsDirectory = document.getFsDirectory();
            String path = luceneIndex.getPath() == null ? luceneConfig.getVfsJson().getPath() : luceneIndex.getPath();
            fsDirectory.setPath(indexRootPathStr + File.separator + path);
            fsDirectory.setTempPath(tempRootPathStr + File.separator + path);
            fsDirectory.setVfsPath(vfsRootPath + path);
            luceneConfig.setFsDirectory(fsDirectory);
            VFSJsonBean vfsjson = document.getVfsJson();
            vfsjson.setPath(indexRootPathStr + File.separator + vfsjson.getPath());
            vfsjson.setVfsPath(vfsRootPath + vfsjson.getVfsPath() + path);
            luceneConfig.setVfsJson(vfsjson);
            luceneConfig.setIndexWriter(document.getIndexWriter());
            luceneConfig.setName(document.getName());
            ArrayList<JField> jfields = new ArrayList<JField>();
            BeanMap beanMap = BeanMap.create((Object)luceneIndex);
            for (Field field : fields = clazz.getDeclaredFields()) {
                JField jfield = (JField)this.getFieldBean(field);
                if (jfield == null) continue;
                jfield.setValue(beanMap.get((Object)field.getName()));
                jfields.add(jfield);
                if (!jfield.getHighlighter().booleanValue() || luceneConfig.getHighFields().contains(jfield.getName())) continue;
                luceneConfig.getHighFields().add(jfield.getName());
            }
            if (valueMap != null) {
                for (String key : valueMap.keySet()) {
                    JFieldBean indexBean = new JFieldBean();
                    indexBean.setClazz(valueMap.get(key).getClass());
                    indexBean.setId(key);
                    indexBean.setName(key);
                    indexBean.setValue(valueMap.get(key));
                    indexBean.setStore(Field.Store.YES);
                    jfields.add(indexBean);
                }
            }
            luceneConfig.setUuid((String)valueMap.get(uuid));
            luceneConfig.setFields(jfields);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return luceneConfig;
    }

    public JLucene getJLuceneConfig(JLuceneIndex luceneIndex) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.getJLuceneConfig(luceneIndex, new HashMap());
    }

    private JIndexBean getIndexBean(Annotation annotation) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<? extends Annotation> enumType = annotation.annotationType();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        ClassMappingAnnotation classMappingAnnotation = annotation.annotationType().getAnnotation(ClassMappingAnnotation.class);
        if (classMappingAnnotation != null) {
            for (int k = 0; k < enumType.getDeclaredMethods().length; ++k) {
                Method method = enumType.getDeclaredMethods()[k];
                if (method.getReturnType().isAnnotation() && method.getReturnType().getAnnotation(ClassMappingAnnotation.class) != null) {
                    Annotation childAnnotation = (Annotation)method.invoke((Object)annotation, null);
                    valueMap.put(method.getName(), this.getIndexBean(childAnnotation));
                    continue;
                }
                if (method.getReturnType().isArray()) {
                    Object[] objs = (Object[])method.invoke((Object)annotation, null);
                    Object[] beans = new Object[objs.length];
                    if (objs.length <= 0) continue;
                    for (int f = 0; f < objs.length; ++f) {
                        if (objs[f] instanceof Annotation) {
                            Annotation obj = (Annotation)objs[f];
                            if (obj.annotationType().getAnnotation(ClassMappingAnnotation.class) != null) {
                                JIndexBean panel = this.getIndexBean(obj);
                                beans[f] = panel;
                                continue;
                            }
                            beans[f] = obj;
                            continue;
                        }
                        beans[f] = objs[f];
                    }
                    valueMap.put(method.getName(), beans);
                    continue;
                }
                valueMap.put(method.getName(), method.invoke((Object)annotation, null));
            }
        }
        JIndexBean indexBean = (JIndexBean)classMappingAnnotation.clazz().newInstance();
        BeanMap beanMap = BeanMap.create((Object)indexBean);
        beanMap.putAll(valueMap);
        return indexBean;
    }

    private JIndexBean getFieldBean(Field field) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        JFieldType annotation = field.getAnnotation(JFieldType.class);
        JField fieldBean = null;
        if (annotation != null) {
            fieldBean = (JField)this.getIndexBean(annotation);
            fieldBean.setId(field.getName());
            fieldBean.setClazz(field.getType());
            if (fieldBean.getName() == null || fieldBean.getName().equals("")) {
                fieldBean.setName(field.getName());
            }
        }
        return fieldBean;
    }

    private JPath getMethodBean(Method method) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        JPathType annotation = method.getAnnotation(JPathType.class);
        JPath pathBean = null;
        if (annotation != null) {
            pathBean = (JPath)this.getIndexBean(annotation);
            pathBean.setId(method.getName());
            pathBean.setClazz(method.getReturnType());
        }
        return pathBean;
    }

    public static void main(String[] args) {
    }
}

