package com.ds.vfs.index;

import com.ds.annotation.JLuceneIndex;
import com.ds.common.Condition;
import com.ds.config.ListResultModel;
import com.ds.index.config.IndexConfigFactroy;
import com.ds.jds.core.esb.EsbUtil;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class CtVFSIndexFactory {
    static CtVFSIndexFactory cacheManager;

    public static final String THREAD_LOCK = "Thread Lock";

    private final IndexConfigFactroy configFactory;

    public static CtVFSIndexFactory getInstance() {
        if (cacheManager == null) {
            synchronized (THREAD_LOCK) {
                cacheManager = new CtVFSIndexFactory();
            }
        }
        return cacheManager;
    }

    CtVFSIndexFactory() {
        this.configFactory = IndexConfigFactroy.getInstance();
    }


    public ListResultModel<List<FileIndex>> search(Condition<FileIndexEnmu, FileIndex> condition) {

        return getService().search(condition);
    }


    public void addIndex(JLuceneIndex index) {
        try {
            getService().addIndex(configFactory.getJLuceneConfig(index));
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        } catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public VFSIndexService getService() {
        VFSIndexService service = EsbUtil.parExpression( VFSIndexService.class);
        return service;
    }
}
