package com.ds.index.web;

import com.ds.annotation.JLuceneIndex;
import com.ds.annotation.MethodChinaName;
import com.ds.common.Condition;
import com.ds.common.ConditionKey;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.index.config.JLucene;
import com.ds.index.service.IndexService;
import com.ds.jds.core.esb.EsbUtil;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
@Controller
@RequestMapping("/api/fts/index")
@MethodChinaName(cname = "索引服务")
//@EsbBeanAnnotation(id = "IndexService")
public class IndexServiceAPI implements IndexService {

    public IndexService getService() {
        IndexService service = EsbUtil.parExpression(IndexService.class);
        return service;
    }
    @MethodChinaName(cname = "添加索引")
    @RequestMapping(method = RequestMethod.POST, value = "/addIndex")
    public @ResponseBody ResultModel<JLucene> addIndex(@RequestBody JLucene luceneBean) {
        return getService().addIndex(luceneBean);
    }

    @MethodChinaName(cname = "删除索引")
    @RequestMapping(method = RequestMethod.POST, value = "/deleteIndex")
    public@ResponseBody
    ResultModel<Boolean> deleteIndex(@RequestBody JLucene luceneBean) {
        return getService().deleteIndex(luceneBean);
    }
    @MethodChinaName(cname = "批量删除索引")
    @RequestMapping(method = RequestMethod.POST, value = "/deleteAllIndex")
    public @ResponseBody  <V extends JLuceneIndex, T extends ConditionKey> ResultModel<Boolean> deleteAllIndex(@RequestBody Condition<T, V> condition) {
        return getService().deleteAllIndex(condition);
    }
    @MethodChinaName(cname = "条件查询")
    @RequestMapping(method = RequestMethod.POST, value = "/search")
    public @ResponseBody <V extends JLuceneIndex, T extends ConditionKey> ListResultModel<List<V>> search(@RequestBody Condition<T, V> condition) {
        return getService().search(condition);
    }
}
