package com.ds.index.service;

import com.ds.common.ConditionKey;
import com.ds.annotation.JLuceneIndex;
import com.ds.common.Condition;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.index.config.JLucene;

import java.util.List;

public interface IndexService {

    /**
     * 添加索引
     * @return
     */
    public  <T extends  JLucene> ResultModel<T> addIndex(T luceneBean);

    /**
     * 根据主键删除索引
     * @return
     */
    public  ResultModel<Boolean>  deleteIndex(JLucene luceneBean) ;

    /**
     * 删除索引
     * @return
     */
    public  <V extends JLuceneIndex,T extends ConditionKey>  ResultModel<Boolean>  deleteAllIndex(Condition<T, V> condition) ;


    /**
     * 根据条件查询
     * @param condition
     * @return
     */
    public <V extends JLuceneIndex,T extends ConditionKey> ListResultModel<List<V>> search(Condition<T, V> condition);
}
