package com.ds.index.config.type;

import com.ds.annotation.ClassMappingAnnotation;
import com.ds.index.config.bean.JFieldBean;
import org.apache.lucene.document.Field.Store;

import java.lang.annotation.*;

/**
 * luecene  index 注解
 *
 * @author wenzhang
 */
@Documented
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@ClassMappingAnnotation(clazz = JFieldBean.class)
public @interface JFieldType {
    //索引名称
    String name() default "";

    //唯一标识
    String id() default "";

    boolean highlighter() default false;

    String converter() default "";

    //索引属性
    Store store() default Store.NO;

}
