package com.ds.vfs.index;

import com.ds.common.query.Condition;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esb.config.EsbBeanAnnotation;
import com.ds.index.config.JLucene;
import com.ds.index.service.IndexService;
import com.ds.jds.core.esb.EsbUtil;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@Controller
@RequestMapping("/api/vfs/index/")
@EsbBeanAnnotation(id = "VFSIndexService")
@MethodChinaName(cname = "检索服务")
public class VFSIndexServiceAPI implements VFSIndexService {

    public IndexService getService() {
        IndexService service = EsbUtil.parExpression("$IndexService", IndexService.class);
        return service;
    }

    @RequestMapping(method = RequestMethod.POST, value = "addIndex")
    @MethodChinaName(cname = "添加索引")
    public @ResponseBody
    ResultModel<JLucene> addIndex(@RequestBody JLucene luceneBean) {
        return getService().addIndex(luceneBean);
    }


    @RequestMapping(method = RequestMethod.POST, value = "deleteIndex")
    @MethodChinaName(cname = "删除索引")
    public @ResponseBody
    ResultModel<Boolean> deleteIndex(@RequestBody Condition<FileIndexEnmu, FileIndex> condition) {
        return getService().deleteAllIndex(condition);
    }


    @RequestMapping(method = RequestMethod.POST, value = "search")
    @MethodChinaName(cname = "条件索引")
    public @ResponseBody
    ListResultModel<List<FileIndex>> search(@RequestBody Condition<FileIndexEnmu, FileIndex> condition) {
        return getService().search(condition);
    }
}
