package com.ds.index.config.type;

import com.ds.esb.config.ClassMappingAnnotation;
import com.ds.index.config.bean.JSyncListenerBean;
import com.ds.index.listener.FileSyncListener;

import java.lang.annotation.*;

@Documented
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@ClassMappingAnnotation(clazz=JSyncListenerBean.class)
public @interface SyncListenerType {

    // VFS 云端VFS对应路径
    String vfsPath() default "";

    // 临时文件路径
    String tempPath() default "";
    
    
    // VFS 云端VFS对应路径
    String vfsRootPath() default "";

    // 临时文件路径
    String tempRootPath() default "";

    // 文件同步监听器
    Class syncListener() default FileSyncListener.class;
    
    

}
