package com.ds.index.config.type;

import com.ds.esb.config.ClassMappingAnnotation;
import com.ds.index.config.bean.JIndexWriterBean;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriterConfig;

import java.lang.annotation.*;

@Documented
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@ClassMappingAnnotation(clazz=JIndexWriterBean.class)
public @interface JIndexWriterType {
    
    String id() default "";
    
    //索引名称
   IndexWriterConfig.OpenMode openMode() default IndexWriterConfig.OpenMode.CREATE_OR_APPEND;
    
    Class analyzer() default StandardAnalyzer.class;
    
   
	

}
