package com.ds.index.config.type;

import com.ds.esb.config.ClassMappingAnnotation;
import com.ds.index.config.bean.JDocumentBean;

import java.lang.annotation.*;

/**
 * luecene  index 注解
 * @author wenzhang
 *
 */
@Documented
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@ClassMappingAnnotation(clazz=JDocumentBean.class)
public @interface JDocumentType{
    
        String id() default "";
    
        //索引名称
        String name() default "";
        
        boolean vfsValid() default true;
        
        boolean indexValid() default true;;
	
	//文件管理器
	FSDirectoryType fsDirectory() default @FSDirectoryType;
	
	//索引配置
	JIndexWriterType indexWriter() default @JIndexWriterType;
	
	//配置
	VFSJsonType vfsJson() default @VFSJsonType;
	
	
}
