package com.ds.index.config.type;

import com.ds.esb.config.ClassMappingAnnotation;
import com.ds.index.config.bean.JFSDirectoryBean;
import org.apache.lucene.store.SimpleFSDirectory;

import java.lang.annotation.*;

@Documented
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@ClassMappingAnnotation(clazz=JFSDirectoryBean.class)
public @interface FSDirectoryType {
    
    

    Class fsDirectoryClass() default SimpleFSDirectory.class;
    
    //文件同步监听器
    SyncListenerType syncListener() default @SyncListenerType;
   
    String id() default "";
    
    // VFS 云端VFS对应路径
    String vfsPath() default "/index/";
    
    //延时执行时间
    long syncDelayTime() default 15000;
   
    
    //最大任务数量
    int maxTaskSize() default 1;


    // 临时文件路径
    String tempPath() default "/index/temp";

    //相对路径
    String path() default "/index/";
 

}
