package com.ds.rad;

import com.ds.common.JDSConstants;
import com.ds.common.JDSException;
import com.ds.common.expression.function.AbstractFunction;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.StringUtility;
import com.ds.context.JDSActionContext;
import com.ds.esb.config.EsbBeanAnnotation;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.ProjectVersion;
import com.ds.vfs.FileInfo;
import com.ds.vfs.Folder;

import java.util.ArrayList;
import java.util.List;

@EsbBeanAnnotation(expressionArr = "ModulesFiles()", id = "ModulesFiles")
public class ModulesFiles extends AbstractFunction {
    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, ModulesFiles.class);

    public ModulesFiles() {

    }

    public List<String> perform() {
        String projectName = (String) JDSActionContext.getActionContext().getParams("projectName");
        List<String> moduleFiles = new ArrayList<String>();
        ProjectVersion version = null;
        try {
            version = getClient().getProjectVersionByName(projectName);
            Folder folder = getClient().getFolderByPath("Module",version.getVersionName());
            if (folder != null) {
                List<FileInfo> fileInfos = folder.getFileListRecursively();
                for (FileInfo moduleFile : fileInfos) {
                    if (moduleFile.getName().endsWith(".cls") && moduleFile.getCurrentVersion() != null && moduleFile.getCurrentVersion().getLength() > 0) {
                        if (!moduleFiles.contains(moduleFile)) {
                            String path=StringUtility.replace(moduleFile.getPath(),version.getPath(),"");
                            moduleFiles.add(path);
                        }
                    }
                }
            }

        } catch (JDSException e) {
            e.printStackTrace();
        }
        return moduleFiles;
    }


    ESDClient getClient() throws JDSException {
        ESDClient client = ESDFacrory.getESDClient();
        return client;
    }
}
