package com.ds.login;

import com.ds.PathUtil;
import com.ds.common.JDSException;
import com.ds.common.swing.util.ImageUtil;
import com.ds.config.UserBean;
import com.ds.editor.ESDEditor;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import java.awt.*;
import java.awt.event.*;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;


public class LoginPanel extends JFrame {
    private static Dimension textFieldDimension = new Dimension(200, 20);
    private TextPanel namePanel;
    private TextPanel passwordPanel;
    private JTextField nameField;
    private JPasswordField passwordField;
    private JTextField serverUrlField;

    private JCheckBox savePasswordField;
    private JCheckBox autoLoginField;
    private UserBean bean;

    static LoginPanel loginPanel;
    JProgressBar bar;
    Timer timer;

    public void clear() {
        nameField.setText("");
        passwordField.setText("");
        autoLoginField.setSelected(false);
        savePasswordField.setSelected(false);
    }


    public void showLoginPanel(UserBean userBean, Boolean swithUser) {

        if (UserBean.getInstance().isAutoLogin() && !swithUser) {
            try {
                ESDEditor.getInstance().login(true, userBean);
                ESDEditor.getInstance().hiddenSplash();
            } catch (JDSException e) {
                ESDEditor.getInstance().hiddenSplash();
                e.printStackTrace();
            }
        } else if (!this.isActive()) {
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);

        }

    }

    public void showError(String errorMsg) {
        if (!this.isActive()) {
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
        ESDEditor.getInstance().hiddenSplash();
        this.namePanel.setErrorText(errorMsg);
    }


    @SuppressWarnings("serial")
    public LoginPanel(UserBean bean) {

        super(bean.getPanelDisplayName());
        this.getContentPane().setLayout(new BorderLayout());
        this.setResizable(false);
        this.setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);
        this.setPreferredSize(new Dimension(430, 341));
        this.setIconImage(ImageUtil.getCoolweiImg());
        this.setUndecorated(true);
        ImageIcon icon = ImageUtil.getImg("background.png");
        JPanel jBrowserPanel = new JPanel() {
            protected void paintComponent(Graphics g) {
                g.drawImage(icon.getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };

        jBrowserPanel.addMouseMotionListener(new MouseMotionListener() {

            int x = LoginPanel.this.getX();
            int y = LoginPanel.this.getY();

            public void mouseDragged(MouseEvent e) {

                int xx = (e.getXOnScreen() - LoginPanel.this.getX());
                int yy = e.getYOnScreen() - LoginPanel.this.getY();
                // System.out.println("xx="+xx+"   LoginPanel.this.getX()="+(LoginPanel.this.getX()+xx-(LoginPanel.this.getWidth()) ));
                //System.out.println("y="+y+"  LoginPanel.this.getX()"+LoginPanel.this.getX());
                LoginPanel.this.move((LoginPanel.this.getX() + xx - (LoginPanel.this.getWidth() / 2)), (LoginPanel.this.getY() + yy - (LoginPanel.this.getHeight() / 2)));
            }

            public void mouseMoved(MouseEvent e) {
                // TODO Auto-generated method stub

            }


        });
        //  jBrowserPanel.setLayout(new BorderLayout());
        this.getContentPane().add(jBrowserPanel);


        JPanel topPanel = new JPanel();

        topPanel.setOpaque(false);
//
//        username=账号
//        password=密码
//        savePassword=记住密码
//        autoLogin=自动登录
//        logout=退出
//        swithuser=切换用户


        topPanel.setBorder(new EmptyBorder(160, 80, 0, 45));
        topPanel.setLayout(new BoxLayout(topPanel, BoxLayout.Y_AXIS));
        topPanel.setAlignmentX(JPanel.CENTER_ALIGNMENT);
        this.namePanel = createTextPanel(PathUtil.getUtfCode(ESDProperties.getInstance().getValue("username")), false);
        this.passwordPanel = createTextPanel(PathUtil.getUtfCode(ESDProperties.getInstance().getValue("password")), true);
        this.nameField = namePanel.getJtf();
        nameField.setText(bean.getUsername());
        this.passwordField = (JPasswordField) passwordPanel.getJtf();
        if (bean.isSavePassword()) {
            passwordField.setText(bean.getUserpassword());
        }

        topPanel.add(namePanel);
        topPanel.add(passwordPanel);


        JPanel checkboxListPanel = new JPanel();
        JPanel savePassword = this.createCheckBoxPanel(PathUtil.getUtfCode(ESDProperties.getInstance().getValue("savePassword")), "");
        JPanel autoLoginPanel = this.createCheckBoxPanel(PathUtil.getUtfCode(ESDProperties.getInstance().getValue("autoLogin")), "");
        checkboxListPanel.add(savePassword);
        checkboxListPanel.add(autoLoginPanel);


        this.savePasswordField = (JCheckBox) savePassword.getComponent(2);
        savePasswordField.setSelected(bean.isSavePassword());
        this.autoLoginField = (JCheckBox) autoLoginPanel.getComponent(2);
        autoLoginField.setSelected(bean.isAutoLogin());

        jBrowserPanel.add(topPanel, BorderLayout.NORTH);

        JPanel sourthPanel = new JPanel();
        sourthPanel.setLayout(new BorderLayout());
        final JPanel buttonPanel = new JPanel();
        sourthPanel.add(buttonPanel, BorderLayout.CENTER);
        bar = new JProgressBar();
        bar.setMinimum(0);
        bar.setMaximum(100);
        bar.setValue(0);
        bar.setStringPainted(true);
        timer = new Timer(50, new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                bar.setValue(bar.getValue() + 1);
            }

        });
        sourthPanel.add(bar, BorderLayout.SOUTH);
        buttonPanel.setLayout(new FlowLayout());
        JPanel nullPnael = new JPanel();
        nullPnael.setPreferredSize(new Dimension(25, 2));
        buttonPanel.add(nullPnael);
        // buttonPanel.setBorder(new EmptyBorder(0,80,50,45));
        final JButton okButton = new JButton();
        ImageIcon loginicon = ImageUtil.getImg("login.png");
        ImageIcon icon2 = ImageUtil.getImg("afterlogin.png");
        ImageIcon icon3 = ImageUtil.getImg("cnacel.png");
        ImageIcon icon4 = ImageUtil.getImg("cnacel2.png");
        okButton.setIcon(loginicon);
        okButton.setPressedIcon(icon2);
        okButton.setBackground(Color.black);
        okButton.setFont(new Font(Font.SANS_SERIF, 0, 15));
        okButton.setContentAreaFilled(true);
        okButton.setBorder(null);
        okButton.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));


        final JButton cancelButton = new JButton();
        cancelButton.setIcon(icon3);
        cancelButton.setPressedIcon(icon4);
        cancelButton.setBorder(null);
        cancelButton.setContentAreaFilled(false);
        cancelButton.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        //  final JButton logoutButton = new JButton("退出");


        KeyListener kl = new KeyListener() {
            public void keyPressed(KeyEvent e) {
                // System.out.println(e);
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    okButton.doClick();
                }
            }
        };

        passwordField.addKeyListener(kl);
        nameField.addKeyListener(kl);
        //serverUrlField.addKeyListener(kl);
        savePasswordField.addKeyListener(kl);
        autoLoginField.addKeyListener(kl);
        passwordField.addFocusListener(new FocusListener() {

            public void focusGained(FocusEvent e) {
                if (!passwordField.isOpaque()) {
                    passwordField.setOpaque(true);
                    passwordField.setText(" ");
                    passwordField.setText("");
                }

            }

            public void focusLost(FocusEvent e) {
                String value = passwordField.getText();
                if (value == null || "".equals(value)) {
                    if (passwordField.isOpaque()) {
                        passwordField.setOpaque(true);
                        passwordField.updateUI();
                    }
                }

            }

        });
        nameField.addFocusListener(new FocusListener() {

            public void focusGained(FocusEvent e) {
                if (!nameField.isOpaque()) {
                    nameField.setOpaque(true);
                    nameField.setText(" ");
                    nameField.setText("");
                }
            }

            public void focusLost(FocusEvent e) {
                String value = nameField.getText();
                if (value == null || "".equals(value)) {
                    if (nameField.isOpaque()) {
                        nameField.setOpaque(false);
                        nameField.updateUI();
                    }
                }
            }

        });


        okButton.addKeyListener(kl);
        ActionListener al = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                UserBean userBean = UserBean.getInstance();
                if (e.getSource() == cancelButton) {
                    ESDEditor.getInstance().getLoginPanel().setVisible(false);
                } else if (e.getSource() == okButton) {
                    if (okButton.isDisplayable()) {
                        userBean.setUsername(nameField.getText());
                        userBean.setUserpassword(passwordField.getText());
                        //userBean.setServerUrl(serverUrlField.getText());
                        userBean.setAutoLogin(autoLoginField.isSelected());
                        userBean.setSavePassword(savePasswordField.isSelected());
                        userBean.props.setProperty("autoLogin", userBean.isAutoLogin() ? "true" : "false");
                        userBean.props.setProperty("savePassword", userBean.isSavePassword() ? "true" : "false");
                        userBean.props.setProperty("username", userBean.getUsername());
                        userBean.props.setProperty("password", userBean.getUserpassword());
                        userBean.props.setProperty("serverUrl", userBean.getServerUrl());
                        try {
                            String runningURL = (new URL(ESDEditor.class
                                    .getProtectionDomain().getCodeSource().getLocation(),
                                    ".")).openConnection().getPermission().getName();
                            userBean.props.save(new FileOutputStream(new File(runningURL + "jdsclient_init.properties")), "changed");

                        } catch (FileNotFoundException e1) {
                            e1.printStackTrace();
                        } catch (IOException e1) {

                            e1.printStackTrace();
                        }
                        okButton.disable();

                        try {
                            ESDEditor.getInstance().login(true, userBean);

                        } catch (JDSException e1) {
                            LoginPanel.this.showError(e1.getMessage());
                            okButton.enable();
                            e1.printStackTrace();
                            return;
                        }


                    }


                }
                //else if(e.getSource() == logoutButton){
                //	System.exit(0);
                //}
            }
        };

        // logoutButton.addActionListener(al);
        okButton.addActionListener(al);
        cancelButton.addActionListener(al);

        buttonPanel.add(okButton);
        //  buttonPanel.add(nullPnael);
        //   buttonPanel.add(cancelButton);
        jBrowserPanel.add(checkboxListPanel, BorderLayout.CENTER);
        jBrowserPanel.add(buttonPanel, BorderLayout.SOUTH);
        //   jBrowserPanel.add(sourthPanel, BorderLayout.SOUTH);


    }

    public UserBean getBean() {
        if (bean == null) {
            bean = UserBean.getInstance();
        }
        bean.setUsername(nameField.getText());
        bean.setServerUrl(serverUrlField.getText());
        bean.setUserpassword(passwordField.getText());
        return bean;
    }

    public void setBean(UserBean bean) {
        this.bean = bean;
    }

    class TextPanel extends JPanel {
        private String title;
        private boolean isPasswordField;
        private JTextField jtf;
        private JLabel jl;

        public JTextField getJtf() {
            return jtf;
        }

        public void setJtf(JTextField jtf) {
            this.jtf = jtf;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setErrorText(String text) {
            jl.setText(text);
            jl.setIcon(ImageUtil.getImg("warning_icon.gif"));
            jl.updateUI();
        }

        TextPanel(String title, boolean isPasswordField) {

            this.title = title;
            this.isPasswordField = isPasswordField;
            this.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
            this.setAlignmentX(JPanel.RIGHT_ALIGNMENT);
            JPanel textPanelWarp = new JPanel();
            //this.setPreferredSize(new Dimension(200, 3));
            // 创建文本域标题
            jl = new JLabel(title);
            jl.setAlignmentX(Component.LEFT_ALIGNMENT);
            jl.setAlignmentY(Component.CENTER_ALIGNMENT);
            jl.setHorizontalAlignment(SwingConstants.RIGHT);
            jl.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            jl.setFont(new Font("微软雅黑", Font.PLAIN, 15));

            // 创建文本域
            this.jtf = null;
            if (!isPasswordField) {
                this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
                jtf = new JTextField();
                jtf.setFont(new Font("隶书", Font.BOLD, 15));
                jtf.getDocument().addDocumentListener(new DocumentListener() {
                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        jl.setText(PathUtil.getUtfCode(ESDProperties.getInstance().getValue("username")));
                        jl.setIcon(null);
                        jl.updateUI();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        jl.setText(PathUtil.getUtfCode(ESDProperties.getInstance().getValue("username")));
                        jl.setIcon(null);
                        jl.updateUI();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        jl.setText(PathUtil.getUtfCode(ESDProperties.getInstance().getValue("username")));
                        jl.setIcon(null);
                        jl.updateUI();
                    }
                });


            } else {
                jtf = new JPasswordField();
                this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            }


            //Font font=;

            jtf.setBorder(BorderFactory.createEmptyBorder());
            jtf.setAlignmentX(Component.LEFT_ALIGNMENT);
            jtf.setAlignmentY(Component.CENTER_ALIGNMENT);
            jtf.setMinimumSize(new Dimension(textFieldDimension));
            jtf.setMaximumSize(new Dimension(textFieldDimension));
            jtf.setPreferredSize(new Dimension(textFieldDimension));
            textPanelWarp.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));

            textPanelWarp.add(jtf);

            this.add(textPanelWarp);
            this.add(jl);

        }
    }

    /**
     * 创建文本域面板
     *
     * @param title           文本域名称
     * @param isPasswordField 文本域是否是密码
     * @return textPanel 返回文本域面板
     */
    private TextPanel createTextPanel(String title, boolean isPasswordField) {
        // 创建文本域面板
        TextPanel textPanel = new TextPanel(title, isPasswordField);

        // 返回文本域面板
        return textPanel;
    }


    /**
     * 创建CHECKBOX域面板
     *
     * @param title 文CHECKBOX名称
     *              文本域是否是密码
     * @return textPanel 返回文本域面板
     */
    private JPanel createCheckBoxPanel(String title, String msg) {
        // 创建文本域面板
        JPanel textPanel = new JPanel();
        textPanel.setPreferredSize(new Dimension(new Dimension(80, 25)));
        textPanel.setLayout(new BoxLayout(textPanel, BoxLayout.X_AXIS));
        textPanel.setAlignmentX(JPanel.LEFT_ALIGNMENT);
        textPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        // 创建文本域标题
        JLabel jl = new JLabel(title);
        jl.setAlignmentX(Component.LEFT_ALIGNMENT);
        jl.setAlignmentY(Component.CENTER_ALIGNMENT);
        jl.setHorizontalAlignment(SwingConstants.RIGHT);
        textPanel.add(jl);
        // 创建文本域
        final JCheckBox jtf;

        ImageIcon icon = ImageUtil.getImg("select.png");
        ImageIcon icon2 = ImageUtil.getImg("selected.png");
        jtf = new JCheckBox();
        jtf.setAlignmentX(Component.LEFT_ALIGNMENT);
        jtf.setAlignmentY(Component.CENTER_ALIGNMENT);
        jtf.setIcon(icon);
        jtf.setSelectedIcon(icon2);


        jl = new JLabel(msg);
        jl.setAlignmentX(Component.LEFT_ALIGNMENT);
        jl.setAlignmentY(Component.CENTER_ALIGNMENT);
        jl.setHorizontalAlignment(SwingConstants.RIGHT);
        jl.setFont(new Font("隶书", Font.BOLD, 15));
        //jl.setFont(new   java.awt.Font(Font.SANS_SERIF,0,15));
        textPanel.add(jl);
        textPanel.add(jtf);
        // 返回文本域面板
        return textPanel;
    }


}

