package com.ds.httpproxy.config;


import com.ds.common.JDSException;
import com.ds.common.cache.CacheSizes;
import com.ds.common.cache.Cacheable;
import com.ds.common.database.DBAgent;

import java.io.Reader;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Script
  implements Cacheable
{
  String uuid;
  String url;
  String script;
  String userid;
  String name;
  Integer scriptindex = Integer.valueOf(0);

  public String getName() {
    return this.name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public String getScript() {
    return this.script;
  }
  public void setScript(String script) {
    this.script = script;
  }
  public String getUrl() {
    return this.url;
  }
  public void setUrl(String url) {
    this.url = url;
  }
  public String getUserid() {
    return this.userid;
  }
  public void setUserid(String userid) {
    this.userid = userid;
  }
  public String getUuid() {
    return this.uuid;
  }
  public void setUuid(String uuid) {
    this.uuid = uuid;
  }
  public Script() {
  }

  public Script(String url) {
    this.url = url;
    loadFromDb();
  }

  public synchronized void loadFromDb()
  {
    DBAgent db = null;
    try {
      db = new DBAgent("coolwei");

      loadBasic(db);
    }
    catch (SQLException e) {
      e.printStackTrace();
    } catch (JDSException e) {
      e.printStackTrace();
    } finally {
      db.close();
    }
  }

  public int getCachedSize()
  {
    int size = 0;
    size += CacheSizes.sizeOfString(this.url);
    size += CacheSizes.sizeOfString(this.name);
    size += CacheSizes.sizeOfString(this.script);
    size += CacheSizes.sizeOfString(this.userid);
    size += CacheSizes.sizeOfString(this.uuid);
    size += CacheSizes.sizeOfObject(this.scriptindex);
    return size;
  }

  private synchronized void loadBasic(DBAgent db) throws SQLException
  {
    ResultSet rs = null;
    String strSql = "select t.* from cw_script t where t.uuid='" + getUuid() + "'";
    if (db.execute(strSql) == 1) {
      rs = db.getQueryResult();
      while (rs.next()) {
        String url = rs.getString("url");
        setUrl(url);
        String name = rs.getString("name");
        setName(name);

        Reader reader = rs.getCharacterStream("script");
        StringWriter writer = new StringWriter();
        try
        {
          int len;
          for (char[] buf = new char[1024]; (len = reader.read(buf)) > 0; )
          {
            writer.write(buf, 0, len);
          }

          writer.close();
        }
        catch (Exception localException) {
        }
        String script = writer.toString();
        setScript(script);
        String userid = rs.getString("userid");
        setUserid(userid);
        Integer scriptindex = Integer.valueOf(rs.getInt("scriptindex"));
        setScriptindex(scriptindex);
      }
    }
  }

  public Integer getScriptindex()
  {
    return this.scriptindex;
  }
  public void setScriptindex(Integer scriptindex) {
    this.scriptindex = scriptindex;
  }
}