package com.ds.httpproxy.config;

import com.ds.common.JDSException;
import com.ds.common.cache.CacheSizes;
import com.ds.common.cache.Cacheable;
import com.ds.common.database.DBAgent;
import com.ds.hsql.HsqlDbCacheManager;
import com.ds.httpproxy.RemoteServerFactory;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RemoteHostProxy
        implements Cacheable {
    String proxyid;
    String url;
    String localIp;
    String port;
    String proxypath;
    List<String> handleIdList;
    private boolean moduleIdList_is_initialized = true;

    public int getCachedSize() {
        int size = 0;
        size += CacheSizes.sizeOfString(this.proxyid);
        size += CacheSizes.sizeOfString(this.localIp);
        size += CacheSizes.sizeOfString(this.url);
        size += CacheSizes.sizeOfString(this.port);
        size += CacheSizes.sizeOfList(this.handleIdList);
        size += CacheSizes.sizeOfString(this.localIp);
        return size;
    }

    public RemoteHostProxy() {
    }

    public RemoteHostProxy(String proxyid) {
        this.proxyid = proxyid;
        if (!HsqlDbCacheManager.isCacheEnabled()) {
            loadFromDb();
        }

    }

    public synchronized void loadFromDbByName(String url) {
        DBAgent db = null;
        try {
            db = new DBAgent("coolwei");

            ResultSet rs = null;
            String strSql = "select proxyid,localip,localport,proxypath from cw_urlproxy t where t.url='" + url + "'";
            if (db.execute(strSql) == 1) {
                rs = db.getQueryResult();
                while (rs.next()) {
                    String proxyId = rs.getString("proxyid");
                    setProxyid(proxyId);
                    String localIp = rs.getString("localip");
                    setLocalIp(localIp);
                    String port = rs.getString("localport");
                    setPort(port);
                    String proxypath = rs.getString("proxypath");
                    setProxypath(proxypath);
                }
                loadHandle(db);
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } catch (JDSException e) {
            e.printStackTrace();
        } finally {
            db.close();
        }
    }

    private synchronized void loadFromDb() {
        DBAgent db = null;
        try {
            db = new DBAgent("coolwei");

            loadBasic(db);
            loadHandle(db);
        } catch (SQLException e) {
            e.printStackTrace();
        } catch (JDSException e) {
            e.printStackTrace();
        } finally {
            db.close();
        }
    }

    void addHandle(String handleid) {
        if (this.handleIdList == null) {
            this.handleIdList = new ArrayList();
        }
        this.handleIdList.add(handleid);
    }

    private synchronized void loadBasic(DBAgent db) throws SQLException {
        ResultSet rs = null;
        String strSql = "select proxyid,url,localip,localport,proxypath from cw_urlproxy t ";
        if (db.execute(strSql) == 1) {
            rs = db.getQueryResult();
            while (rs.next()) {
                String proxyId = rs.getString("proxyid");
                setProxyid(proxyId);
                String url = rs.getString("url");
                setUrl(url);
                String localIp = rs.getString("localip");
                setLocalIp(localIp);
                String port = rs.getString("localport");
                setPort(port);
                String proxypath = rs.getString("proxypath");
                setProxypath(proxypath);
            }
        }
        rs.close();
    }

    private void prepareModules() {
        if (!HsqlDbCacheManager.isCacheEnabled()) {
            if (!this.moduleIdList_is_initialized) {
                DBAgent db = null;
                try {
                    db = new DBAgent("coolwei");

                        loadHandle(db);
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    db.close();
                }
            }
        }
    }

    private void loadHandle(DBAgent db)
            throws SQLException {
        ResultSet rs = null;
        String strSql = "select handleid from cw_handle_ref_proxy  where proxyid='" + getProxyid() + "' ";
        if (db.execute(strSql) == 1) {
            rs = db.getQueryResult();
            while (rs.next()) {
                String handleid = rs.getString("handleid");
                addHandle(handleid);
            }
        }
        this.moduleIdList_is_initialized = true;
    }

    public List<Handle> getHandleList() {


        prepareModules();
        if (this.handleIdList == null) {
            return new ArrayList();
        }
        List<Handle> handleList = new ArrayList();
        RemoteServerFactory cacheManager = RemoteServerFactory.getInstance();
        int i = 0;
        for (int n = this.handleIdList.size(); i < n; i++) {
            String handleid = (String) this.handleIdList.get(i);
            handleList.add(cacheManager.getHandleById(handleid));
        }
        return handleList;
    }

    public List<String> getHandleIdList() {
        return this.handleIdList;
    }

    public void setHandleIdList(List<String> handleIdList) {
        this.handleIdList = handleIdList;
    }

    public String getLocalIp() {
        return this.localIp;
    }

    public void setLocalIp(String localIp) {
        this.localIp = localIp;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getProxyid() {
        return this.proxyid;
    }

    public void setProxyid(String proxyid) {
        this.proxyid = proxyid;
    }

    public String getProxypath() {
        return this.proxypath;
    }

    public void setProxypath(String proxypath) {
        this.proxypath = proxypath;
    }
}