package com.ds.httpproxy.config;

import com.ds.common.JDSException;
import com.ds.common.cache.CacheSizes;
import com.ds.common.cache.Cacheable;
import com.ds.common.database.DBAgent;
import com.ds.common.database.DBBeanBase;
import com.ds.httpproxy.RemoteServerFactory;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;


public class Page
        implements Cacheable {
    String url;
    List<String> scriptIds = new ArrayList();
    boolean scriptIdinit = false;

    public Page(String url) {
        this.url = url;
        loadScript();
    }

    public synchronized void addScript(String script) {
        DBBeanBase db = new DBBeanBase("coolwei", true);
        try {
            String uuid = UUID.randomUUID().toString();
            String strSql = "insert into  cw_script (uuid,url,script) values ( ?,?,?)";
            PreparedStatement ps = db.getConn().prepareStatement(strSql,
                    1004,
                    1007);
            int _dirtyCount = 0;
            ps.setString(++_dirtyCount, uuid);
            ps.setString(++_dirtyCount, this.url);
            ps.setString(++_dirtyCount, script);
            ps.execute();
            db.commit();
            this.scriptIds.add(uuid);
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            db.close();
        }
    }

    public synchronized void deleteScriptById(String uuid) throws SQLException {
        DBAgent db = null;
        try {
            db = new DBAgent("coolwei");

            String strSql = "delete cw_script t where t.uuid='" + uuid + "'";
            db.execute(strSql);
        } catch (JDSException e) {
            e.printStackTrace();
        } finally {
            db.close();
        }
    }

    public List<Script> getScripts() {
        List scripts = new ArrayList();

        if (!this.scriptIdinit) {
            loadScript();
        }
        for (int k = 0; k < this.scriptIds.size(); k++) {
            Script script = RemoteServerFactory.getInstance().getScriptById((String) this.scriptIds.get(k));
            scripts.add(script);
        }
        return scripts;
    }

    private void loadScript() {
        ResultSet rs = null;
        DBAgent db = null;
        try {
            db = new DBAgent("coolwei");

            String strSql = "select t.* from cw_script t where t.url='" + this.url + "' order by scriptindex asc";
            if (db.execute(strSql) == 1) {
                rs = db.getQueryResult();
                try {
                    while (rs.next()) {
                        String uuid = rs.getString("uuid");
                        this.scriptIds.add(uuid);
                    }
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            this.scriptIdinit = true;
        } catch (JDSException e) {
            e.printStackTrace();
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            db.close();
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getCachedSize() {
        int size = 0;
        size += CacheSizes.sizeOfString(this.url);
        size += CacheSizes.sizeOfList(this.scriptIds);
        return size;
    }
}