package com.ds.httpproxy.config;

import com.ds.common.JDSException;
import com.ds.common.cache.CacheSizes;
import com.ds.common.cache.Cacheable;
import com.ds.common.database.DBAgent;

import java.sql.ResultSet;
import java.sql.SQLException;

public class Handle
  implements Cacheable
{
  String handleid;
  String classname;
  String handname;
  String urlPrefix;
  String rule;

  public Handle()
  {
  }

  public Handle(String handleid)
  {
    this.handleid = handleid;
    loadFromDb();
  }

  public synchronized void loadFromDb()
  {


    DBAgent db = null;
    try {
      db = new DBAgent("coolwei");

      loadBasic(db);
    }
    catch (SQLException e) {
      e.printStackTrace();
    } catch (JDSException e) {
      e.printStackTrace();
    } finally {
      db.close();
    }
  }

  public int getCachedSize()
  {
    int size = 0;
    size += CacheSizes.sizeOfString(this.handleid);
    size += CacheSizes.sizeOfString(this.classname);
    size += CacheSizes.sizeOfString(this.handname);
    size += CacheSizes.sizeOfString(this.urlPrefix);
    size += CacheSizes.sizeOfString(this.rule);
    return size;
  }

  public synchronized void loadBasic(DBAgent db) throws SQLException
  {
    ResultSet rs = null;
    String strSql = "select t.handleid,t.classname,t.urlprefix,t.ruletext, t.name from cw_handle t where t.handleid='" + getHandleid() + "'";
    if (db.execute(strSql) == 1) {
      rs = db.getQueryResult();
      while (rs.next()) {
        String handleid = rs.getString("handleid");
        setHandleid(handleid);
        String classname = rs.getString("classname");
        setClassname(classname);
        String handname = rs.getString("name");
        setHandname(handname);
        String rule = rs.getString("ruletext");
        setRule(rule);
        String urlPrefix = rs.getString("urlprefix");
        setUrlPrefix(urlPrefix);
      }
    }
  }

  public String getClassname()
  {
    return this.classname;
  }
  public void setClassname(String classname) {
    this.classname = classname;
  }
  public String getRule() {
    return this.rule;
  }
  public void setRule(String rule) {
    this.rule = rule;
  }
  public String getUrlPrefix() {
    return this.urlPrefix;
  }
  public void setUrlPrefix(String urlPrefix) {
    this.urlPrefix = urlPrefix;
  }
  public String getHandleid() {
    return this.handleid;
  }
  public void setHandleid(String handleid) {
    this.handleid = handleid;
  }
  public String getHandname() {
    return this.handname;
  }
  public void setHandname(String handname) {
    this.handname = handname;
  }
}