package com.ds.httpproxy.config;

import com.ds.common.JDSException;
import com.ds.common.cache.CacheSizes;
import com.ds.common.cache.Cacheable;
import com.ds.common.database.DBAgent;

import java.io.Reader;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ChannelScript
        implements Cacheable {
    String uuid;
    String url;
    String parentId;
    String pageScript;
    String inforlistScript;
    String inforScript;
    String userid;
    String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ChannelScript() {
    }

    public ChannelScript(String uuid) {
        this.uuid = uuid;
        loadFromDb();
    }

    public synchronized void loadFromDb() {
        DBAgent db = null;
        try {
            db = new DBAgent("coolwei");

            loadBasic(db);
        } catch (SQLException e) {
            e.printStackTrace();
        } catch (JDSException e) {
            e.printStackTrace();
        } finally {
            db.close();
        }
    }

    public int getCachedSize() {
        int size = 0;
        size += CacheSizes.sizeOfString(this.url);
        size += CacheSizes.sizeOfString(this.name);
        size += CacheSizes.sizeOfString(this.pageScript);
        size += CacheSizes.sizeOfString(this.inforlistScript);
        size += CacheSizes.sizeOfString(this.inforScript);
        size += CacheSizes.sizeOfString(this.parentId);
        size += CacheSizes.sizeOfString(this.userid);
        size += CacheSizes.sizeOfString(this.uuid);

        return size;
    }

    private String getLobString(Reader reader) {
        StringWriter writer = new StringWriter();
        try {
            int len;
            for (char[] buf = new char[1024]; (len = reader.read(buf)) > 0; ) {
                writer.write(buf, 0, len);
            }

            writer.close();
        } catch (Exception localException) {
        }
        String script = writer.toString();
        return script;
    }

    private synchronized void loadBasic(DBAgent db) throws SQLException {
        ResultSet rs = null;
        String strSql = "select t.* from ER_CHANNEL t where t.CHANNELUID='" + getUuid() + "'";
        if (db.execute(strSql) == 1) {
            rs = db.getQueryResult();
            while (rs.next()) {
                String url = rs.getString("CHANNELURL");
                setUrl(url);
                String name = rs.getString("CHANNELNAME");
                setName(name);
                setPageScript(getLobString(rs.getCharacterStream("PAGESCRIPT")));
                setInforlistScript(getLobString(rs.getCharacterStream("INFORLISTSCRIPT")));
            }
        }
    }

    public String getInforlistScript() {
        return this.inforlistScript;
    }

    public void setInforlistScript(String inforlistScript) {
        this.inforlistScript = inforlistScript;
    }

    public String getInforScript() {
        return this.inforScript;
    }

    public void setInforScript(String inforScript) {
        this.inforScript = inforScript;
    }

    public String getPageScript() {
        return this.pageScript;
    }

    public void setPageScript(String pageScript) {
        this.pageScript = pageScript;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }
}