package com.ds.httpproxy.config;

import com.ds.common.JDSException;
import com.ds.common.cache.CacheSizes;
import com.ds.common.cache.Cacheable;
import com.ds.common.database.DBAgent;
import com.ds.httpproxy.RemoteServerFactory;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ChannelPage
  implements Cacheable
{
  String url;
  List<String> scriptIds = new ArrayList();
  boolean scriptIdinit = false;

  public ChannelPage(String url) {
    this.url = url;
    loadScript();
  }

  public List<ChannelScript> getScripts()
  {
    List scripts = new ArrayList();

    if (!this.scriptIdinit) {
      loadScript();
    }
    for (int k = 0; k < this.scriptIds.size(); k++) {
      ChannelScript script = RemoteServerFactory.getInstance().getChannelScriptById((String)this.scriptIds.get(k));
      scripts.add(script);
    }
    return scripts;
  }

  private void loadScript() {
    ResultSet rs = null;
    DBAgent db = null;
    try {
      db = new DBAgent("coolwei");

      String strSql = "select t.* from ER_CHANNEL t where t.CHANNELURL='" + this.url + "' ";
      if (db.execute(strSql) == 1) {
        rs = db.getQueryResult();
        try {
          while (rs.next()) {
            String uuid = rs.getString("channeluid");
            this.scriptIds.add(uuid);
          }
        } catch (SQLException e) {
          e.printStackTrace();
        }
      }
      this.scriptIdinit = true;
    } catch (JDSException e) {
      e.printStackTrace();
    } catch (SQLException e) {
      e.printStackTrace();
    } finally {
      db.close();
    }
  }

  public String getUrl() {
    return this.url;
  }
  public void setUrl(String url) {
    this.url = url;
  }

  public int getCachedSize()
  {
    int size = 0;
    size += CacheSizes.sizeOfString(this.url);
    size += CacheSizes.sizeOfList(this.scriptIds);
    return size;
  }
}