package com.ds.httpproxy;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ExplorerUtil
{
  protected static final String LS = System.getProperty("line.separator");
  private static final String EXTJSNAME = "Ext.js";
  private static final String EXTCSSPATH = "ext-3.0.0/resources/css/ext-all.css";

  public static String getRunningUrl(String path)
  {
    String runningURL = "";
    try {
      runningURL = new URL(
        ExplorerUtil.class.getProtectionDomain().getCodeSource().getLocation(), 
        ".").openConnection().getPermission().getName().substring(1).replace("\\", "/");
    } catch (MalformedURLException e1) {
      e1.printStackTrace();
    } catch (IOException e1) {
      e1.printStackTrace();
    }
    return runningURL + path;
  }
  public static String getLoadCssScript() {
    String js = 
      " function LoadCss(href){var headObj = document.getElementsByTagName('head')[0];srciptObj = document.createElement('link');srciptObj.rel = 'stylesheet';srciptObj.type = 'text/css';srciptObj.href = href;headObj.appendChild(srciptObj);}";

    return js;
  }

  public static String getJsScript()
  {
    String js = 
      " function LoadScript(src){var headObj = document.getElementsByTagName('head')[0];srciptObj = document.createElement('script');srciptObj.type = 'text/javascript';srciptObj.href = src;headObj.appendChild(srciptObj);}";

    return js;
  }

  public static String getJSFileByUrl(String url)
    throws IOException
  {
    BufferedReader br = new BufferedReader(new FileReader(url));
    StringBuffer sb = new StringBuffer();
    String lineContent = null;
    while ((lineContent = br.readLine()) != null) {
      sb.append(lineContent);
      sb.append("\n");
    }
    String js = sb.toString();
    return js;
  }

  public static String initConsonlScript() throws IOException {
    StringBuffer base = new StringBuffer("");
    base.append(getJSFileByUrl(getRunningUrl("Ext.js")));
    base.append(";");
    base.append(getLoadCssScript());
    base.append(";");
    base.append("LoadCss('" + getRunningUrl("ext-3.0.0/resources/css/ext-all.css") + "')");
    base.append(";");
    base.append("JDS.startConsol()");
    String basestr = base.toString();
    return basestr;
  }
}