package com.ds.handler;


import com.alibaba.fastjson.JSONObject;
import com.ds.common.JDSException;
import com.ds.common.md5.MD5InputStream;
import com.ds.config.ResultModel;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.ProjectVersion;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import com.ds.server.httpproxy.handler.multipart.SimpleRequestContext;
import com.ds.vfs.FileInfo;
import com.ds.vfs.Folder;
import com.ds.vfs.VFSConstants;
import org.apache.commons.fileupload.*;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;


public class UPLoadHandler extends AbstractHandler {
    Pattern rule;

    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        return true;
    }


    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        String resource = request.getPath();
        boolean ruleMatches = rule.matcher(resource).matches();
        if (!ruleMatches) {
            return false;
        }
        String mimeType = getMimeType(resource);
        if (mimeType != null) {
            response.setMimeType(mimeType);
        }
        String contentType = this.getContentType(request);
        if (contentType != null && contentType.indexOf("multipart/form-data") > -1) {
            return this.sendMultiparPostProxy(request, response);
        }

        return true;
    }


    public boolean sendMultiparPostProxy(HttpRequest request, HttpResponse response) throws IOException {
        Map<String, String> params = new HashMap<String, String>();
        // 获取服务器响应的IO流
        RequestContext requestContext = new SimpleRequestContext(StandardCharsets.UTF_8, this.getContentType(request), new ByteArrayInputStream(request.getPostData()));
        // 解析器创建
        FileUploadBase fileUploadBase = new PortletFileUpload();
        FileItemFactory fileItemFactory = new DiskFileItemFactory();
        fileUploadBase.setFileItemFactory(fileItemFactory);
        fileUploadBase.setHeaderEncoding(VFSConstants.CONFIG_CTVFS_KEY);
        // 解析出所有的部件
        List<FileItem> fileItems = null;
        try {
            fileItems = fileUploadBase.parseRequest(requestContext);
        } catch (FileUploadException e) {
            e.printStackTrace();
        }


        ResultModel<XUIFile> result = new ResultModel<XUIFile>();

        for (FileItem f : fileItems) {
            if (f.isFormField()) {
                if (f != null && f.get() != null && f.get().length > 0) {
                    params.put(f.getFieldName(), f.getString());
                }
            }
        }


        for (FileItem f : fileItems) {
            if (!f.isFormField()) {
                String projectName = params.get("projectName");
                String uploadpath = params.get("uploadpath");
                if (uploadpath == null) {
                    uploadpath = "";
                }
                try {
                    XUIFile xuiFile = uploadFile(uploadpath, projectName, f);
                    result.setData(xuiFile);
                } catch (JDSException e) {
                    e.printStackTrace();
                }
            }
        }

        response.sendJSONResponse(JSONObject.toJSONString(result));
        return true;


    }

    XUIFile uploadFile(String uploadpath, String projectName, FileItem f) throws JDSException, IOException {
        ESDClient client = ESDFacrory.getESDClient();
        ProjectVersion version = client.getProjectVersionByName(projectName);
        if (uploadpath.equals(projectName)) {
            uploadpath = "";
        }
        Folder tfolder = client.getFolderByPath(uploadpath, version.getVersionName());
        if (tfolder == null) {
            tfolder = version.createFolder(uploadpath);
        }
        FileInfo fileInfo = client.uploadFile(new MD5InputStream(f.getInputStream()), tfolder.getPath() + f.getName());
        return new XUIFile(fileInfo, version);

    }


    public String getContentType(HttpRequest request) {

        String contentType = request.getRequestHeader("Content-Type");
        if (contentType == null) {
            contentType = request.getRequestHeader("Content-type");
        }
        return contentType;
    }


}
