package com.ds.handler;

import com.ds.config.JDSUtil;
import com.ds.server.httpproxy.core.*;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;


public class ResourceHandler extends AbstractHandler implements Handler {
    private static final Logger log = Logger.getLogger(com.ds.server.httpproxy.handler.ResourceHandler.class.getName());
    private String resourceMount;
    private String defaultResource;


    Pattern rule;

    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.resourceMount = RESOURCE_MOUNT_OPTION.getProperty(server, handlerName);
        this.defaultResource = DEFAULT_RESOURCE_OPTION.getProperty(server, handlerName);
        rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        return true;
    }


    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {

        String path = request.getPath();

        boolean ruleMatches = rule.matcher(path).matches();
        String projectName = null;
        if (this.getServer().getProxyHost() != null) {
            projectName = this.getServer().getProxyHost().getProjectName();
        }

        boolean projectMatches = false;
        if (projectName != null) {
            Pattern projectRule = Pattern.compile(".*/(" + projectName + ")?.*");
            projectMatches = projectRule.matcher(path).matches();
        }

        if (!ruleMatches && !projectMatches) {
            return false;
        }


        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        if (projectName == null) {
            projectName = path;
            if (path.indexOf("/") > -1) {
                projectName = path.substring(0, path.indexOf("/"));
            }
        }


        String resource = Http.join(resourceMount, path);
        if (resource.endsWith("/")) {
            resource += defaultResource;
        } else if (resource.lastIndexOf('.') < 0) {
            resource += "/" + defaultResource;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Loading resource: " + resource);
        }
        String mimeType = getMimeType(resource);

        File file = new File(JDSUtil.getJdsRealPath() + resource);

        InputStream is = null;

        if (file.exists()) {
            is = new FileInputStream(file);
        }

        if (mimeType == null || is == null) {
            log.warning("Resource was not found or the mime type was not understood. (Found file=" + (is != null) + ") (Found mime-type=" + (mimeType != null) + ")");
            return false;
        }
        if (is != null) {
            response.setMimeType(mimeType);
            response.sendResponse(is, Integer.valueOf(Long.toString(file.length())));
            return true;
        } else {
            return false;
        }


    }


}
